package zio.aws.directconnect
import zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.directconnect.DirectConnectAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.directconnect.model.{
  DescribeLoaRequest,
  AllocateTransitVirtualInterfaceRequest,
  CreateLagRequest,
  AcceptDirectConnectGatewayAssociationProposalRequest,
  DescribeVirtualInterfacesRequest,
  AllocatePrivateVirtualInterfaceRequest,
  UpdateDirectConnectGatewayRequest,
  ConfirmPrivateVirtualInterfaceRequest,
  CreateBgpPeerRequest,
  DescribeDirectConnectGatewayAttachmentsRequest,
  AssociateVirtualInterfaceRequest,
  CreateConnectionRequest,
  DeleteVirtualInterfaceRequest,
  UpdateLagRequest,
  ConfirmCustomerAgreementRequest,
  CreatePublicVirtualInterfaceRequest,
  AllocateHostedConnectionRequest,
  UpdateVirtualInterfaceAttributesRequest,
  DeleteDirectConnectGatewayRequest,
  DescribeConnectionsRequest,
  DescribeRouterConfigurationRequest,
  DisassociateMacSecKeyRequest,
  DescribeInterconnectsRequest,
  DeleteLagRequest,
  DescribeHostedConnectionsRequest,
  StopBgpFailoverTestRequest,
  CreateDirectConnectGatewayRequest,
  AssociateConnectionWithLagRequest,
  AllocatePublicVirtualInterfaceRequest,
  UpdateDirectConnectGatewayAssociationRequest,
  DeleteDirectConnectGatewayAssociationProposalRequest,
  DescribeDirectConnectGatewaysRequest,
  AssociateMacSecKeyRequest,
  DeleteConnectionRequest,
  StartBgpFailoverTestRequest,
  ConfirmConnectionRequest,
  CreateInterconnectRequest,
  ListVirtualInterfaceTestHistoryRequest,
  DeleteDirectConnectGatewayAssociationRequest,
  CreateDirectConnectGatewayAssociationProposalRequest,
  CreateTransitVirtualInterfaceRequest,
  DescribeDirectConnectGatewayAssociationProposalsRequest,
  DescribeTagsRequest,
  UpdateConnectionRequest,
  DeleteBgpPeerRequest,
  ConfirmTransitVirtualInterfaceRequest,
  DisassociateConnectionFromLagRequest,
  UntagResourceRequest,
  AssociateHostedConnectionRequest,
  DescribeLagsRequest,
  DescribeDirectConnectGatewayAssociationsRequest,
  CreateDirectConnectGatewayAssociationRequest,
  CreatePrivateVirtualInterfaceRequest,
  DeleteInterconnectRequest,
  TagResourceRequest,
  ConfirmPublicVirtualInterfaceRequest
}
object DirectConnectMock extends Mock[DirectConnect] {
  object AllocatePrivateVirtualInterface
      extends Effect[AllocatePrivateVirtualInterfaceRequest, AwsError, ReadOnly]
  object CreateTransitVirtualInterface
      extends Effect[
        CreateTransitVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly
      ]
  object DescribeTags
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly
      ]
  object DisassociateMacSecKey
      extends Effect[
        DisassociateMacSecKeyRequest,
        AwsError,
        zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly
      ]
  object StopBgpFailoverTest
      extends Effect[
        StopBgpFailoverTestRequest,
        AwsError,
        zio.aws.directconnect.model.StopBgpFailoverTestResponse.ReadOnly
      ]
  object CreateDirectConnectGateway
      extends Effect[
        CreateDirectConnectGatewayRequest,
        AwsError,
        zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly
      ]
  object AssociateHostedConnection
      extends Effect[
        AssociateHostedConnectionRequest,
        AwsError,
        zio.aws.directconnect.model.AssociateHostedConnectionResponse.ReadOnly
      ]
  object DescribeDirectConnectGatewayAttachments
      extends Effect[
        DescribeDirectConnectGatewayAttachmentsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly
      ]
  object DescribeDirectConnectGateways
      extends Effect[
        DescribeDirectConnectGatewaysRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly
      ]
  object AssociateMacSecKey
      extends Effect[
        AssociateMacSecKeyRequest,
        AwsError,
        zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly
      ]
  object ListVirtualInterfaceTestHistory
      extends Effect[
        ListVirtualInterfaceTestHistoryRequest,
        AwsError,
        zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly
      ]
  object DisassociateConnectionFromLag
      extends Effect[
        DisassociateConnectionFromLagRequest,
        AwsError,
        zio.aws.directconnect.model.DisassociateConnectionFromLagResponse.ReadOnly
      ]
  object AllocateHostedConnection
      extends Effect[
        AllocateHostedConnectionRequest,
        AwsError,
        zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly
      ]
  object DescribeHostedConnections
      extends Effect[
        DescribeHostedConnectionsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly
      ]
  object UpdateDirectConnectGateway
      extends Effect[
        UpdateDirectConnectGatewayRequest,
        AwsError,
        zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly
      ]
  object CreateConnection
      extends Effect[
        CreateConnectionRequest,
        AwsError,
        zio.aws.directconnect.model.CreateConnectionResponse.ReadOnly
      ]
  object ConfirmPublicVirtualInterface
      extends Effect[
        ConfirmPublicVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly
      ]
  object StartBgpFailoverTest
      extends Effect[
        StartBgpFailoverTestRequest,
        AwsError,
        zio.aws.directconnect.model.StartBgpFailoverTestResponse.ReadOnly
      ]
  object UpdateConnection
      extends Effect[
        UpdateConnectionRequest,
        AwsError,
        zio.aws.directconnect.model.UpdateConnectionResponse.ReadOnly
      ]
  object DeleteDirectConnectGatewayAssociation
      extends Effect[
        DeleteDirectConnectGatewayAssociationRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly
      ]
  object DescribeRouterConfiguration
      extends Effect[
        DescribeRouterConfigurationRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly
      ]
  object UpdateLag
      extends Effect[
        UpdateLagRequest,
        AwsError,
        zio.aws.directconnect.model.UpdateLagResponse.ReadOnly
      ]
  object DeleteBGPPeer
      extends Effect[
        DeleteBgpPeerRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteBgpPeerResponse.ReadOnly
      ]
  object ConfirmCustomerAgreement
      extends Effect[
        ConfirmCustomerAgreementRequest,
        AwsError,
        zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly
      ]
  object ConfirmConnection
      extends Effect[
        ConfirmConnectionRequest,
        AwsError,
        zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly
      ]
  object DescribeDirectConnectGatewayAssociations
      extends Effect[
        DescribeDirectConnectGatewayAssociationsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly
      ]
  object AcceptDirectConnectGatewayAssociationProposal
      extends Effect[
        AcceptDirectConnectGatewayAssociationProposalRequest,
        AwsError,
        zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly
      ]
  object AllocatePublicVirtualInterface
      extends Effect[
        AllocatePublicVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.AllocatePublicVirtualInterfaceResponse.ReadOnly
      ]
  object DeleteVirtualInterface
      extends Effect[
        DeleteVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly
      ]
  object CreatePublicVirtualInterface
      extends Effect[
        CreatePublicVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.CreatePublicVirtualInterfaceResponse.ReadOnly
      ]
  object DeleteInterconnect
      extends Effect[
        DeleteInterconnectRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.directconnect.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteLag
      extends Effect[
        DeleteLagRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteLagResponse.ReadOnly
      ]
  object DescribeVirtualInterfaces
      extends Effect[
        DescribeVirtualInterfacesRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly
      ]
  object DescribeInterconnects
      extends Effect[
        DescribeInterconnectsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly
      ]
  object DeleteDirectConnectGateway
      extends Effect[
        DeleteDirectConnectGatewayRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteDirectConnectGatewayResponse.ReadOnly
      ]
  object CreatePrivateVirtualInterface
      extends Effect[
        CreatePrivateVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.CreatePrivateVirtualInterfaceResponse.ReadOnly
      ]
  object DescribeLags
      extends Effect[
        DescribeLagsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly
      ]
  object DescribeLocations
      extends Effect[
        Unit,
        AwsError,
        zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly
      ]
  object CreateBGPPeer
      extends Effect[
        CreateBgpPeerRequest,
        AwsError,
        zio.aws.directconnect.model.CreateBgpPeerResponse.ReadOnly
      ]
  object AllocateTransitVirtualInterface
      extends Effect[
        AllocateTransitVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly
      ]
  object AssociateVirtualInterface
      extends Effect[
        AssociateVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly
      ]
  object ConfirmPrivateVirtualInterface
      extends Effect[
        ConfirmPrivateVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly
      ]
  object UpdateDirectConnectGatewayAssociation
      extends Effect[
        UpdateDirectConnectGatewayAssociationRequest,
        AwsError,
        zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteConnectionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.directconnect.model.TagResourceResponse.ReadOnly
      ]
  object DeleteDirectConnectGatewayAssociationProposal
      extends Effect[
        DeleteDirectConnectGatewayAssociationProposalRequest,
        AwsError,
        zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly
      ]
  object UpdateVirtualInterfaceAttributes
      extends Effect[
        UpdateVirtualInterfaceAttributesRequest,
        AwsError,
        zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesResponse.ReadOnly
      ]
  object ConfirmTransitVirtualInterface
      extends Effect[
        ConfirmTransitVirtualInterfaceRequest,
        AwsError,
        zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly
      ]
  object DescribeVirtualGateways
      extends Effect[
        Unit,
        AwsError,
        zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly
      ]
  object DescribeDirectConnectGatewayAssociationProposals
      extends Effect[
        DescribeDirectConnectGatewayAssociationProposalsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly
      ]
  object DescribeCustomerMetadata
      extends Effect[
        Unit,
        AwsError,
        zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly
      ]
  object DescribeConnections
      extends Effect[
        DescribeConnectionsRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly
      ]
  object CreateDirectConnectGatewayAssociation
      extends Effect[
        CreateDirectConnectGatewayAssociationRequest,
        AwsError,
        zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationResponse.ReadOnly
      ]
  object CreateInterconnect
      extends Effect[
        CreateInterconnectRequest,
        AwsError,
        zio.aws.directconnect.model.CreateInterconnectResponse.ReadOnly
      ]
  object CreateDirectConnectGatewayAssociationProposal
      extends Effect[
        CreateDirectConnectGatewayAssociationProposalRequest,
        AwsError,
        zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly
      ]
  object CreateLag
      extends Effect[
        CreateLagRequest,
        AwsError,
        zio.aws.directconnect.model.CreateLagResponse.ReadOnly
      ]
  object AssociateConnectionWithLag
      extends Effect[
        AssociateConnectionWithLagRequest,
        AwsError,
        zio.aws.directconnect.model.AssociateConnectionWithLagResponse.ReadOnly
      ]
  object DescribeLoa
      extends Effect[
        DescribeLoaRequest,
        AwsError,
        zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DirectConnect] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new DirectConnect {
          val api: DirectConnectAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : DirectConnect = this
          def allocatePrivateVirtualInterface(
              request: AllocatePrivateVirtualInterfaceRequest
          ): IO[AwsError, ReadOnly] =
            proxy(AllocatePrivateVirtualInterface, request)
          def createTransitVirtualInterface(
              request: CreateTransitVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly
          ] = proxy(CreateTransitVirtualInterface, request)
          def describeTags(request: DescribeTagsRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly
          ] = proxy(DescribeTags, request)
          def disassociateMacSecKey(request: DisassociateMacSecKeyRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly
          ] = proxy(DisassociateMacSecKey, request)
          def stopBgpFailoverTest(request: StopBgpFailoverTestRequest): IO[
            AwsError,
            zio.aws.directconnect.model.StopBgpFailoverTestResponse.ReadOnly
          ] = proxy(StopBgpFailoverTest, request)
          def createDirectConnectGateway(
              request: CreateDirectConnectGatewayRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly
          ] = proxy(CreateDirectConnectGateway, request)
          def associateHostedConnection(
              request: AssociateHostedConnectionRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AssociateHostedConnectionResponse.ReadOnly
          ] = proxy(AssociateHostedConnection, request)
          def describeDirectConnectGatewayAttachments(
              request: DescribeDirectConnectGatewayAttachmentsRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly
          ] = proxy(DescribeDirectConnectGatewayAttachments, request)
          def describeDirectConnectGateways(
              request: DescribeDirectConnectGatewaysRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly
          ] = proxy(DescribeDirectConnectGateways, request)
          def associateMacSecKey(request: AssociateMacSecKeyRequest): IO[
            AwsError,
            zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly
          ] = proxy(AssociateMacSecKey, request)
          def listVirtualInterfaceTestHistory(
              request: ListVirtualInterfaceTestHistoryRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly
          ] = proxy(ListVirtualInterfaceTestHistory, request)
          def disassociateConnectionFromLag(
              request: DisassociateConnectionFromLagRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DisassociateConnectionFromLagResponse.ReadOnly
          ] = proxy(DisassociateConnectionFromLag, request)
          def allocateHostedConnection(
              request: AllocateHostedConnectionRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly
          ] = proxy(AllocateHostedConnection, request)
          def describeHostedConnections(
              request: DescribeHostedConnectionsRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly
          ] = proxy(DescribeHostedConnections, request)
          def updateDirectConnectGateway(
              request: UpdateDirectConnectGatewayRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly
          ] = proxy(UpdateDirectConnectGateway, request)
          def createConnection(request: CreateConnectionRequest): IO[
            AwsError,
            zio.aws.directconnect.model.CreateConnectionResponse.ReadOnly
          ] = proxy(CreateConnection, request)
          def confirmPublicVirtualInterface(
              request: ConfirmPublicVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly
          ] = proxy(ConfirmPublicVirtualInterface, request)
          def startBgpFailoverTest(request: StartBgpFailoverTestRequest): IO[
            AwsError,
            zio.aws.directconnect.model.StartBgpFailoverTestResponse.ReadOnly
          ] = proxy(StartBgpFailoverTest, request)
          def updateConnection(request: UpdateConnectionRequest): IO[
            AwsError,
            zio.aws.directconnect.model.UpdateConnectionResponse.ReadOnly
          ] = proxy(UpdateConnection, request)
          def deleteDirectConnectGatewayAssociation(
              request: DeleteDirectConnectGatewayAssociationRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly
          ] = proxy(DeleteDirectConnectGatewayAssociation, request)
          def describeRouterConfiguration(
              request: DescribeRouterConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly
          ] = proxy(DescribeRouterConfiguration, request)
          def updateLag(request: UpdateLagRequest): IO[
            AwsError,
            zio.aws.directconnect.model.UpdateLagResponse.ReadOnly
          ] = proxy(UpdateLag, request)
          def deleteBGPPeer(request: DeleteBgpPeerRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteBgpPeerResponse.ReadOnly
          ] = proxy(DeleteBGPPeer, request)
          def confirmCustomerAgreement(
              request: ConfirmCustomerAgreementRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly
          ] = proxy(ConfirmCustomerAgreement, request)
          def confirmConnection(request: ConfirmConnectionRequest): IO[
            AwsError,
            zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly
          ] = proxy(ConfirmConnection, request)
          def describeDirectConnectGatewayAssociations(
              request: DescribeDirectConnectGatewayAssociationsRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly
          ] = proxy(DescribeDirectConnectGatewayAssociations, request)
          def acceptDirectConnectGatewayAssociationProposal(
              request: AcceptDirectConnectGatewayAssociationProposalRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly
          ] = proxy(AcceptDirectConnectGatewayAssociationProposal, request)
          def allocatePublicVirtualInterface(
              request: AllocatePublicVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AllocatePublicVirtualInterfaceResponse.ReadOnly
          ] = proxy(AllocatePublicVirtualInterface, request)
          def deleteVirtualInterface(
              request: DeleteVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly
          ] = proxy(DeleteVirtualInterface, request)
          def createPublicVirtualInterface(
              request: CreatePublicVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.CreatePublicVirtualInterfaceResponse.ReadOnly
          ] = proxy(CreatePublicVirtualInterface, request)
          def deleteInterconnect(request: DeleteInterconnectRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly
          ] = proxy(DeleteInterconnect, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.directconnect.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def deleteLag(request: DeleteLagRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteLagResponse.ReadOnly
          ] = proxy(DeleteLag, request)
          def describeVirtualInterfaces(
              request: DescribeVirtualInterfacesRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly
          ] = proxy(DescribeVirtualInterfaces, request)
          def describeInterconnects(request: DescribeInterconnectsRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly
          ] = proxy(DescribeInterconnects, request)
          def deleteDirectConnectGateway(
              request: DeleteDirectConnectGatewayRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteDirectConnectGatewayResponse.ReadOnly
          ] = proxy(DeleteDirectConnectGateway, request)
          def createPrivateVirtualInterface(
              request: CreatePrivateVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.CreatePrivateVirtualInterfaceResponse.ReadOnly
          ] = proxy(CreatePrivateVirtualInterface, request)
          def describeLags(request: DescribeLagsRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly
          ] = proxy(DescribeLags, request)
          def describeLocations(): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly
          ] = proxy(DescribeLocations)
          def createBGPPeer(request: CreateBgpPeerRequest): IO[
            AwsError,
            zio.aws.directconnect.model.CreateBgpPeerResponse.ReadOnly
          ] = proxy(CreateBGPPeer, request)
          def allocateTransitVirtualInterface(
              request: AllocateTransitVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly
          ] = proxy(AllocateTransitVirtualInterface, request)
          def associateVirtualInterface(
              request: AssociateVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly
          ] = proxy(AssociateVirtualInterface, request)
          def confirmPrivateVirtualInterface(
              request: ConfirmPrivateVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly
          ] = proxy(ConfirmPrivateVirtualInterface, request)
          def updateDirectConnectGatewayAssociation(
              request: UpdateDirectConnectGatewayAssociationRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly
          ] = proxy(UpdateDirectConnectGatewayAssociation, request)
          def deleteConnection(request: DeleteConnectionRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteConnectionResponse.ReadOnly
          ] = proxy(DeleteConnection, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.directconnect.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def deleteDirectConnectGatewayAssociationProposal(
              request: DeleteDirectConnectGatewayAssociationProposalRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly
          ] = proxy(DeleteDirectConnectGatewayAssociationProposal, request)
          def updateVirtualInterfaceAttributes(
              request: UpdateVirtualInterfaceAttributesRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesResponse.ReadOnly
          ] = proxy(UpdateVirtualInterfaceAttributes, request)
          def confirmTransitVirtualInterface(
              request: ConfirmTransitVirtualInterfaceRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly
          ] = proxy(ConfirmTransitVirtualInterface, request)
          def describeVirtualGateways(): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly
          ] = proxy(DescribeVirtualGateways)
          def describeDirectConnectGatewayAssociationProposals(
              request: DescribeDirectConnectGatewayAssociationProposalsRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly
          ] = proxy(DescribeDirectConnectGatewayAssociationProposals, request)
          def describeCustomerMetadata(): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly
          ] = proxy(DescribeCustomerMetadata)
          def describeConnections(request: DescribeConnectionsRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly
          ] = proxy(DescribeConnections, request)
          def createDirectConnectGatewayAssociation(
              request: CreateDirectConnectGatewayAssociationRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationResponse.ReadOnly
          ] = proxy(CreateDirectConnectGatewayAssociation, request)
          def createInterconnect(request: CreateInterconnectRequest): IO[
            AwsError,
            zio.aws.directconnect.model.CreateInterconnectResponse.ReadOnly
          ] = proxy(CreateInterconnect, request)
          def createDirectConnectGatewayAssociationProposal(
              request: CreateDirectConnectGatewayAssociationProposalRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly
          ] = proxy(CreateDirectConnectGatewayAssociationProposal, request)
          def createLag(request: CreateLagRequest): IO[
            AwsError,
            zio.aws.directconnect.model.CreateLagResponse.ReadOnly
          ] = proxy(CreateLag, request)
          def associateConnectionWithLag(
              request: AssociateConnectionWithLagRequest
          ): IO[
            AwsError,
            zio.aws.directconnect.model.AssociateConnectionWithLagResponse.ReadOnly
          ] = proxy(AssociateConnectionWithLag, request)
          def describeLoa(request: DescribeLoaRequest): IO[
            AwsError,
            zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly
          ] = proxy(DescribeLoa, request)
        }
      }
    }
    .toLayer
}
