package zio.aws.directconnect
import zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.directconnect.model.{
  DescribeCustomerMetadataResponse,
  DescribeLoaRequest,
  AllocateTransitVirtualInterfaceRequest,
  CreateLagRequest,
  AcceptDirectConnectGatewayAssociationProposalRequest,
  DescribeLoaResponse,
  DescribeVirtualInterfacesRequest,
  DeleteInterconnectResponse,
  ConfirmConnectionResponse,
  AllocatePrivateVirtualInterfaceRequest,
  UpdateDirectConnectGatewayRequest,
  ConfirmPrivateVirtualInterfaceRequest,
  DeleteConnectionResponse,
  CreateBgpPeerRequest,
  DescribeDirectConnectGatewayAttachmentsRequest,
  AssociateVirtualInterfaceRequest,
  CreateConnectionRequest,
  ConfirmPublicVirtualInterfaceResponse,
  ConfirmCustomerAgreementResponse,
  DeleteVirtualInterfaceRequest,
  UpdateLagRequest,
  CreateBgpPeerResponse,
  ConfirmCustomerAgreementRequest,
  AllocateHostedConnectionResponse,
  CreatePublicVirtualInterfaceRequest,
  AllocateTransitVirtualInterfaceResponse,
  AllocateHostedConnectionRequest,
  UpdateVirtualInterfaceAttributesRequest,
  DeleteDirectConnectGatewayAssociationResponse,
  UpdateVirtualInterfaceAttributesResponse,
  DescribeVirtualGatewaysResponse,
  DeleteDirectConnectGatewayRequest,
  DescribeConnectionsRequest,
  AssociateHostedConnectionResponse,
  DescribeRouterConfigurationRequest,
  AllocatePrivateVirtualInterfaceResponse,
  DescribeRouterConfigurationResponse,
  DisassociateMacSecKeyRequest,
  DescribeInterconnectsRequest,
  DeleteLagRequest,
  StartBgpFailoverTestResponse,
  CreateConnectionResponse,
  DescribeCustomerMetadataRequest,
  DeleteDirectConnectGatewayAssociationProposalResponse,
  AssociateConnectionWithLagResponse,
  DescribeLocationsResponse,
  DescribeHostedConnectionsRequest,
  StopBgpFailoverTestRequest,
  CreateDirectConnectGatewayRequest,
  AssociateConnectionWithLagRequest,
  AllocatePublicVirtualInterfaceRequest,
  DescribeDirectConnectGatewayAssociationsResponse,
  CreateDirectConnectGatewayResponse,
  CreateInterconnectResponse,
  UpdateDirectConnectGatewayAssociationRequest,
  DeleteDirectConnectGatewayAssociationProposalRequest,
  DeleteVirtualInterfaceResponse,
  DescribeDirectConnectGatewaysRequest,
  DescribeConnectionsResponse,
  CreatePublicVirtualInterfaceResponse,
  DescribeVirtualInterfacesResponse,
  UntagResourceResponse,
  AssociateMacSecKeyRequest,
  DeleteConnectionRequest,
  StartBgpFailoverTestRequest,
  ConfirmConnectionRequest,
  CreateInterconnectRequest,
  ListVirtualInterfaceTestHistoryRequest,
  DescribeLocationsRequest,
  DeleteDirectConnectGatewayAssociationRequest,
  DeleteLagResponse,
  CreateDirectConnectGatewayAssociationProposalRequest,
  DeleteBgpPeerResponse,
  CreateDirectConnectGatewayAssociationResponse,
  CreateTransitVirtualInterfaceRequest,
  DeleteDirectConnectGatewayResponse,
  DescribeDirectConnectGatewayAssociationProposalsRequest,
  CreateTransitVirtualInterfaceResponse,
  DisassociateMacSecKeyResponse,
  DescribeDirectConnectGatewayAssociationProposalsResponse,
  DescribeLagsResponse,
  DescribeTagsRequest,
  ConfirmTransitVirtualInterfaceResponse,
  UpdateConnectionRequest,
  DeleteBgpPeerRequest,
  ConfirmTransitVirtualInterfaceRequest,
  DescribeVirtualGatewaysRequest,
  AssociateMacSecKeyResponse,
  DisassociateConnectionFromLagRequest,
  DisassociateConnectionFromLagResponse,
  UntagResourceRequest,
  AssociateHostedConnectionRequest,
  UpdateLagResponse,
  AcceptDirectConnectGatewayAssociationProposalResponse,
  DescribeLagsRequest,
  DescribeHostedConnectionsResponse,
  UpdateDirectConnectGatewayResponse,
  AssociateVirtualInterfaceResponse,
  DescribeDirectConnectGatewayAssociationsRequest,
  StopBgpFailoverTestResponse,
  CreatePrivateVirtualInterfaceResponse,
  CreateDirectConnectGatewayAssociationRequest,
  DescribeTagsResponse,
  TagResourceResponse,
  DescribeInterconnectsResponse,
  CreatePrivateVirtualInterfaceRequest,
  DeleteInterconnectRequest,
  ConfirmPrivateVirtualInterfaceResponse,
  DescribeDirectConnectGatewayAttachmentsResponse,
  AllocatePublicVirtualInterfaceResponse,
  CreateDirectConnectGatewayAssociationProposalResponse,
  TagResourceRequest,
  UpdateDirectConnectGatewayAssociationResponse,
  UpdateConnectionResponse,
  ListVirtualInterfaceTestHistoryResponse,
  DescribeDirectConnectGatewaysResponse,
  CreateLagResponse,
  ConfirmPublicVirtualInterfaceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.directconnect.{
  DirectConnectAsyncClientBuilder,
  DirectConnectAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters._
trait DirectConnect extends AspectSupport[DirectConnect] {
  val api: DirectConnectAsyncClient
  def allocatePrivateVirtualInterface(
      request: zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest
  ): IO[AwsError, ReadOnly]
  def createTransitVirtualInterface(
      request: zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly
  ]
  def describeTags(
      request: zio.aws.directconnect.model.DescribeTagsRequest
  ): IO[AwsError, zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly]
  def disassociateMacSecKey(
      request: zio.aws.directconnect.model.DisassociateMacSecKeyRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly
  ]
  def stopBgpFailoverTest(
      request: zio.aws.directconnect.model.StopBgpFailoverTestRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.StopBgpFailoverTestResponse.ReadOnly
  ]
  def createDirectConnectGateway(
      request: zio.aws.directconnect.model.CreateDirectConnectGatewayRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly
  ]
  def associateHostedConnection(
      request: zio.aws.directconnect.model.AssociateHostedConnectionRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AssociateHostedConnectionResponse.ReadOnly
  ]
  def describeDirectConnectGatewayAttachments(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly
  ]
  def describeDirectConnectGateways(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly
  ]
  def associateMacSecKey(
      request: zio.aws.directconnect.model.AssociateMacSecKeyRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly
  ]
  def listVirtualInterfaceTestHistory(
      request: zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly
  ]
  def disassociateConnectionFromLag(
      request: zio.aws.directconnect.model.DisassociateConnectionFromLagRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DisassociateConnectionFromLagResponse.ReadOnly
  ]
  def allocateHostedConnection(
      request: zio.aws.directconnect.model.AllocateHostedConnectionRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly
  ]
  def describeHostedConnections(
      request: zio.aws.directconnect.model.DescribeHostedConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly
  ]
  def updateDirectConnectGateway(
      request: zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly
  ]
  def createConnection(
      request: zio.aws.directconnect.model.CreateConnectionRequest
  ): IO[AwsError, zio.aws.directconnect.model.CreateConnectionResponse.ReadOnly]
  def confirmPublicVirtualInterface(
      request: zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly
  ]
  def startBgpFailoverTest(
      request: zio.aws.directconnect.model.StartBgpFailoverTestRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.StartBgpFailoverTestResponse.ReadOnly
  ]
  def updateConnection(
      request: zio.aws.directconnect.model.UpdateConnectionRequest
  ): IO[AwsError, zio.aws.directconnect.model.UpdateConnectionResponse.ReadOnly]
  def deleteDirectConnectGatewayAssociation(
      request: zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly
  ]
  def describeRouterConfiguration(
      request: zio.aws.directconnect.model.DescribeRouterConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly
  ]
  def updateLag(
      request: zio.aws.directconnect.model.UpdateLagRequest
  ): IO[AwsError, zio.aws.directconnect.model.UpdateLagResponse.ReadOnly]
  def deleteBGPPeer(
      request: zio.aws.directconnect.model.DeleteBgpPeerRequest
  ): IO[AwsError, zio.aws.directconnect.model.DeleteBgpPeerResponse.ReadOnly]
  def confirmCustomerAgreement(
      request: zio.aws.directconnect.model.ConfirmCustomerAgreementRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly
  ]
  def confirmConnection(
      request: zio.aws.directconnect.model.ConfirmConnectionRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly
  ]
  def describeDirectConnectGatewayAssociations(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly
  ]
  def acceptDirectConnectGatewayAssociationProposal(
      request: zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly
  ]
  def allocatePublicVirtualInterface(
      request: zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AllocatePublicVirtualInterfaceResponse.ReadOnly
  ]
  def deleteVirtualInterface(
      request: zio.aws.directconnect.model.DeleteVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly
  ]
  def createPublicVirtualInterface(
      request: zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreatePublicVirtualInterfaceResponse.ReadOnly
  ]
  def deleteInterconnect(
      request: zio.aws.directconnect.model.DeleteInterconnectRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.directconnect.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.directconnect.model.UntagResourceResponse.ReadOnly]
  def deleteLag(
      request: zio.aws.directconnect.model.DeleteLagRequest
  ): IO[AwsError, zio.aws.directconnect.model.DeleteLagResponse.ReadOnly]
  def describeVirtualInterfaces(
      request: zio.aws.directconnect.model.DescribeVirtualInterfacesRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly
  ]
  def describeInterconnects(
      request: zio.aws.directconnect.model.DescribeInterconnectsRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly
  ]
  def deleteDirectConnectGateway(
      request: zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DeleteDirectConnectGatewayResponse.ReadOnly
  ]
  def createPrivateVirtualInterface(
      request: zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreatePrivateVirtualInterfaceResponse.ReadOnly
  ]
  def describeLags(
      request: zio.aws.directconnect.model.DescribeLagsRequest
  ): IO[AwsError, zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly]
  def describeLocations(): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly
  ]
  def createBGPPeer(
      request: zio.aws.directconnect.model.CreateBgpPeerRequest
  ): IO[AwsError, zio.aws.directconnect.model.CreateBgpPeerResponse.ReadOnly]
  def allocateTransitVirtualInterface(
      request: zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly
  ]
  def associateVirtualInterface(
      request: zio.aws.directconnect.model.AssociateVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly
  ]
  def confirmPrivateVirtualInterface(
      request: zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly
  ]
  def updateDirectConnectGatewayAssociation(
      request: zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly
  ]
  def deleteConnection(
      request: zio.aws.directconnect.model.DeleteConnectionRequest
  ): IO[AwsError, zio.aws.directconnect.model.DeleteConnectionResponse.ReadOnly]
  def tagResource(
      request: zio.aws.directconnect.model.TagResourceRequest
  ): IO[AwsError, zio.aws.directconnect.model.TagResourceResponse.ReadOnly]
  def deleteDirectConnectGatewayAssociationProposal(
      request: zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly
  ]
  def updateVirtualInterfaceAttributes(
      request: zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesResponse.ReadOnly
  ]
  def confirmTransitVirtualInterface(
      request: zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly
  ]
  def describeVirtualGateways(): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly
  ]
  def describeDirectConnectGatewayAssociationProposals(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly
  ]
  def describeCustomerMetadata(): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly
  ]
  def describeConnections(
      request: zio.aws.directconnect.model.DescribeConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly
  ]
  def createDirectConnectGatewayAssociation(
      request: zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationResponse.ReadOnly
  ]
  def createInterconnect(
      request: zio.aws.directconnect.model.CreateInterconnectRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreateInterconnectResponse.ReadOnly
  ]
  def createDirectConnectGatewayAssociationProposal(
      request: zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly
  ]
  def createLag(
      request: zio.aws.directconnect.model.CreateLagRequest
  ): IO[AwsError, zio.aws.directconnect.model.CreateLagResponse.ReadOnly]
  def associateConnectionWithLag(
      request: zio.aws.directconnect.model.AssociateConnectionWithLagRequest
  ): IO[
    AwsError,
    zio.aws.directconnect.model.AssociateConnectionWithLagResponse.ReadOnly
  ]
  def describeLoa(
      request: zio.aws.directconnect.model.DescribeLoaRequest
  ): IO[AwsError, zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly]
}
object DirectConnect {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DirectConnect] = customized(
    identity
  )
  def customized(
      customization: DirectConnectAsyncClientBuilder => DirectConnectAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DirectConnect] = managed(
    customization
  ).toLayer
  def managed(
      customization: DirectConnectAsyncClientBuilder => DirectConnectAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, DirectConnect] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = DirectConnectAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DirectConnectAsyncClient, DirectConnectAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        DirectConnectAsyncClient,
        DirectConnectAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new DirectConnectImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class DirectConnectImpl[R](
      override val api: DirectConnectAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DirectConnect
      with AwsServiceBase[R] {
    override val serviceName: String = "DirectConnect"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DirectConnectImpl[R1] = new DirectConnectImpl(api, newAspect, r)
    def allocatePrivateVirtualInterface(
        request: zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      AllocatePrivateVirtualInterfaceRequest,
      AllocatePrivateVirtualInterfaceResponse
    ]("allocatePrivateVirtualInterface", api.allocatePrivateVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def createTransitVirtualInterface(
        request: zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitVirtualInterfaceRequest,
      CreateTransitVirtualInterfaceResponse
    ]("createTransitVirtualInterface", api.createTransitVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def describeTags(
        request: zio.aws.directconnect.model.DescribeTagsRequest
    ): IO[AwsError, zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly] =
      asyncRequestResponse[DescribeTagsRequest, DescribeTagsResponse](
        "describeTags",
        api.describeTags
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.DescribeTagsResponse.wrap)
        .provideEnvironment(r)
    def disassociateMacSecKey(
        request: zio.aws.directconnect.model.DisassociateMacSecKeyRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMacSecKeyRequest,
      DisassociateMacSecKeyResponse
    ]("disassociateMacSecKey", api.disassociateMacSecKey)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DisassociateMacSecKeyResponse.wrap)
      .provideEnvironment(r)
    def stopBgpFailoverTest(
        request: zio.aws.directconnect.model.StopBgpFailoverTestRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.StopBgpFailoverTestResponse.ReadOnly
    ] = asyncRequestResponse[
      StopBgpFailoverTestRequest,
      StopBgpFailoverTestResponse
    ]("stopBgpFailoverTest", api.stopBgpFailoverTest)(request.buildAwsValue())
      .map(zio.aws.directconnect.model.StopBgpFailoverTestResponse.wrap)
      .provideEnvironment(r)
    def createDirectConnectGateway(
        request: zio.aws.directconnect.model.CreateDirectConnectGatewayRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDirectConnectGatewayRequest,
      CreateDirectConnectGatewayResponse
    ]("createDirectConnectGateway", api.createDirectConnectGateway)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.wrap)
      .provideEnvironment(r)
    def associateHostedConnection(
        request: zio.aws.directconnect.model.AssociateHostedConnectionRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AssociateHostedConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateHostedConnectionRequest,
      AssociateHostedConnectionResponse
    ]("associateHostedConnection", api.associateHostedConnection)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.AssociateHostedConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeDirectConnectGatewayAttachments(
        request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDirectConnectGatewayAttachmentsRequest,
      DescribeDirectConnectGatewayAttachmentsResponse
    ](
      "describeDirectConnectGatewayAttachments",
      api.describeDirectConnectGatewayAttachments
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.wrap
      )
      .provideEnvironment(r)
    def describeDirectConnectGateways(
        request: zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDirectConnectGatewaysRequest,
      DescribeDirectConnectGatewaysResponse
    ]("describeDirectConnectGateways", api.describeDirectConnectGateways)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.wrap
    ).provideEnvironment(r)
    def associateMacSecKey(
        request: zio.aws.directconnect.model.AssociateMacSecKeyRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMacSecKeyRequest,
      AssociateMacSecKeyResponse
    ]("associateMacSecKey", api.associateMacSecKey)(request.buildAwsValue())
      .map(zio.aws.directconnect.model.AssociateMacSecKeyResponse.wrap)
      .provideEnvironment(r)
    def listVirtualInterfaceTestHistory(
        request: zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVirtualInterfaceTestHistoryRequest,
      ListVirtualInterfaceTestHistoryResponse
    ]("listVirtualInterfaceTestHistory", api.listVirtualInterfaceTestHistory)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.wrap
    ).provideEnvironment(r)
    def disassociateConnectionFromLag(
        request: zio.aws.directconnect.model.DisassociateConnectionFromLagRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DisassociateConnectionFromLagResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateConnectionFromLagRequest,
      DisassociateConnectionFromLagResponse
    ]("disassociateConnectionFromLag", api.disassociateConnectionFromLag)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.DisassociateConnectionFromLagResponse.wrap
    ).provideEnvironment(r)
    def allocateHostedConnection(
        request: zio.aws.directconnect.model.AllocateHostedConnectionRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      AllocateHostedConnectionRequest,
      AllocateHostedConnectionResponse
    ]("allocateHostedConnection", api.allocateHostedConnection)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.AllocateHostedConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeHostedConnections(
        request: zio.aws.directconnect.model.DescribeHostedConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeHostedConnectionsRequest,
      DescribeHostedConnectionsResponse
    ]("describeHostedConnections", api.describeHostedConnections)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DescribeHostedConnectionsResponse.wrap)
      .provideEnvironment(r)
    def updateDirectConnectGateway(
        request: zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDirectConnectGatewayRequest,
      UpdateDirectConnectGatewayResponse
    ]("updateDirectConnectGateway", api.updateDirectConnectGateway)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.wrap)
      .provideEnvironment(r)
    def createConnection(
        request: zio.aws.directconnect.model.CreateConnectionRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[CreateConnectionRequest, CreateConnectionResponse](
      "createConnection",
      api.createConnection
    )(request.buildAwsValue())
      .map(zio.aws.directconnect.model.CreateConnectionResponse.wrap)
      .provideEnvironment(r)
    def confirmPublicVirtualInterface(
        request: zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      ConfirmPublicVirtualInterfaceRequest,
      ConfirmPublicVirtualInterfaceResponse
    ]("confirmPublicVirtualInterface", api.confirmPublicVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def startBgpFailoverTest(
        request: zio.aws.directconnect.model.StartBgpFailoverTestRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.StartBgpFailoverTestResponse.ReadOnly
    ] = asyncRequestResponse[
      StartBgpFailoverTestRequest,
      StartBgpFailoverTestResponse
    ]("startBgpFailoverTest", api.startBgpFailoverTest)(request.buildAwsValue())
      .map(zio.aws.directconnect.model.StartBgpFailoverTestResponse.wrap)
      .provideEnvironment(r)
    def updateConnection(
        request: zio.aws.directconnect.model.UpdateConnectionRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.UpdateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[UpdateConnectionRequest, UpdateConnectionResponse](
      "updateConnection",
      api.updateConnection
    )(request.buildAwsValue())
      .map(zio.aws.directconnect.model.UpdateConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteDirectConnectGatewayAssociation(
        request: zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDirectConnectGatewayAssociationRequest,
      DeleteDirectConnectGatewayAssociationResponse
    ](
      "deleteDirectConnectGatewayAssociation",
      api.deleteDirectConnectGatewayAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def describeRouterConfiguration(
        request: zio.aws.directconnect.model.DescribeRouterConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRouterConfigurationRequest,
      DescribeRouterConfigurationResponse
    ]("describeRouterConfiguration", api.describeRouterConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DescribeRouterConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateLag(
        request: zio.aws.directconnect.model.UpdateLagRequest
    ): IO[AwsError, zio.aws.directconnect.model.UpdateLagResponse.ReadOnly] =
      asyncRequestResponse[UpdateLagRequest, UpdateLagResponse](
        "updateLag",
        api.updateLag
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.UpdateLagResponse.wrap)
        .provideEnvironment(r)
    def deleteBGPPeer(
        request: zio.aws.directconnect.model.DeleteBgpPeerRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteBgpPeerResponse.ReadOnly
    ] = asyncRequestResponse[DeleteBgpPeerRequest, DeleteBgpPeerResponse](
      "deleteBGPPeer",
      api.deleteBGPPeer
    )(request.buildAwsValue())
      .map(zio.aws.directconnect.model.DeleteBgpPeerResponse.wrap)
      .provideEnvironment(r)
    def confirmCustomerAgreement(
        request: zio.aws.directconnect.model.ConfirmCustomerAgreementRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly
    ] = asyncRequestResponse[
      ConfirmCustomerAgreementRequest,
      ConfirmCustomerAgreementResponse
    ]("confirmCustomerAgreement", api.confirmCustomerAgreement)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.wrap)
      .provideEnvironment(r)
    def confirmConnection(
        request: zio.aws.directconnect.model.ConfirmConnectionRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly
    ] =
      asyncRequestResponse[ConfirmConnectionRequest, ConfirmConnectionResponse](
        "confirmConnection",
        api.confirmConnection
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.ConfirmConnectionResponse.wrap)
        .provideEnvironment(r)
    def describeDirectConnectGatewayAssociations(
        request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDirectConnectGatewayAssociationsRequest,
      DescribeDirectConnectGatewayAssociationsResponse
    ](
      "describeDirectConnectGatewayAssociations",
      api.describeDirectConnectGatewayAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def acceptDirectConnectGatewayAssociationProposal(
        request: zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptDirectConnectGatewayAssociationProposalRequest,
      AcceptDirectConnectGatewayAssociationProposalResponse
    ](
      "acceptDirectConnectGatewayAssociationProposal",
      api.acceptDirectConnectGatewayAssociationProposal
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.wrap
      )
      .provideEnvironment(r)
    def allocatePublicVirtualInterface(
        request: zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AllocatePublicVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      AllocatePublicVirtualInterfaceRequest,
      AllocatePublicVirtualInterfaceResponse
    ]("allocatePublicVirtualInterface", api.allocatePublicVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.AllocatePublicVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def deleteVirtualInterface(
        request: zio.aws.directconnect.model.DeleteVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVirtualInterfaceRequest,
      DeleteVirtualInterfaceResponse
    ]("deleteVirtualInterface", api.deleteVirtualInterface)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.wrap)
      .provideEnvironment(r)
    def createPublicVirtualInterface(
        request: zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreatePublicVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePublicVirtualInterfaceRequest,
      CreatePublicVirtualInterfaceResponse
    ]("createPublicVirtualInterface", api.createPublicVirtualInterface)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.CreatePublicVirtualInterfaceResponse.wrap)
      .provideEnvironment(r)
    def deleteInterconnect(
        request: zio.aws.directconnect.model.DeleteInterconnectRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteInterconnectRequest,
      DeleteInterconnectResponse
    ]("deleteInterconnect", api.deleteInterconnect)(request.buildAwsValue())
      .map(zio.aws.directconnect.model.DeleteInterconnectResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.directconnect.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.directconnect.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteLag(
        request: zio.aws.directconnect.model.DeleteLagRequest
    ): IO[AwsError, zio.aws.directconnect.model.DeleteLagResponse.ReadOnly] =
      asyncRequestResponse[DeleteLagRequest, DeleteLagResponse](
        "deleteLag",
        api.deleteLag
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.DeleteLagResponse.wrap)
        .provideEnvironment(r)
    def describeVirtualInterfaces(
        request: zio.aws.directconnect.model.DescribeVirtualInterfacesRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVirtualInterfacesRequest,
      DescribeVirtualInterfacesResponse
    ]("describeVirtualInterfaces", api.describeVirtualInterfaces)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.wrap)
      .provideEnvironment(r)
    def describeInterconnects(
        request: zio.aws.directconnect.model.DescribeInterconnectsRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInterconnectsRequest,
      DescribeInterconnectsResponse
    ]("describeInterconnects", api.describeInterconnects)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DescribeInterconnectsResponse.wrap)
      .provideEnvironment(r)
    def deleteDirectConnectGateway(
        request: zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteDirectConnectGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDirectConnectGatewayRequest,
      DeleteDirectConnectGatewayResponse
    ]("deleteDirectConnectGateway", api.deleteDirectConnectGateway)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.DeleteDirectConnectGatewayResponse.wrap)
      .provideEnvironment(r)
    def createPrivateVirtualInterface(
        request: zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreatePrivateVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePrivateVirtualInterfaceRequest,
      CreatePrivateVirtualInterfaceResponse
    ]("createPrivateVirtualInterface", api.createPrivateVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.CreatePrivateVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def describeLags(
        request: zio.aws.directconnect.model.DescribeLagsRequest
    ): IO[AwsError, zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly] =
      asyncRequestResponse[DescribeLagsRequest, DescribeLagsResponse](
        "describeLags",
        api.describeLags
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.DescribeLagsResponse.wrap)
        .provideEnvironment(r)
    def describeLocations(): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeLocationsRequest, DescribeLocationsResponse](
        "describeLocations",
        api.describeLocations
      )(DescribeLocationsRequest.builder().build())
        .map(zio.aws.directconnect.model.DescribeLocationsResponse.wrap)
        .provideEnvironment(r)
    def createBGPPeer(
        request: zio.aws.directconnect.model.CreateBgpPeerRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateBgpPeerResponse.ReadOnly
    ] = asyncRequestResponse[CreateBgpPeerRequest, CreateBgpPeerResponse](
      "createBGPPeer",
      api.createBGPPeer
    )(request.buildAwsValue())
      .map(zio.aws.directconnect.model.CreateBgpPeerResponse.wrap)
      .provideEnvironment(r)
    def allocateTransitVirtualInterface(
        request: zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      AllocateTransitVirtualInterfaceRequest,
      AllocateTransitVirtualInterfaceResponse
    ]("allocateTransitVirtualInterface", api.allocateTransitVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def associateVirtualInterface(
        request: zio.aws.directconnect.model.AssociateVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateVirtualInterfaceRequest,
      AssociateVirtualInterfaceResponse
    ]("associateVirtualInterface", api.associateVirtualInterface)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.wrap)
      .provideEnvironment(r)
    def confirmPrivateVirtualInterface(
        request: zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      ConfirmPrivateVirtualInterfaceRequest,
      ConfirmPrivateVirtualInterfaceResponse
    ]("confirmPrivateVirtualInterface", api.confirmPrivateVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def updateDirectConnectGatewayAssociation(
        request: zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDirectConnectGatewayAssociationRequest,
      UpdateDirectConnectGatewayAssociationResponse
    ](
      "updateDirectConnectGatewayAssociation",
      api.updateDirectConnectGatewayAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteConnection(
        request: zio.aws.directconnect.model.DeleteConnectionRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteConnectionResponse.ReadOnly
    ] = asyncRequestResponse[DeleteConnectionRequest, DeleteConnectionResponse](
      "deleteConnection",
      api.deleteConnection
    )(request.buildAwsValue())
      .map(zio.aws.directconnect.model.DeleteConnectionResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.directconnect.model.TagResourceRequest
    ): IO[AwsError, zio.aws.directconnect.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteDirectConnectGatewayAssociationProposal(
        request: zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDirectConnectGatewayAssociationProposalRequest,
      DeleteDirectConnectGatewayAssociationProposalResponse
    ](
      "deleteDirectConnectGatewayAssociationProposal",
      api.deleteDirectConnectGatewayAssociationProposal
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.wrap
      )
      .provideEnvironment(r)
    def updateVirtualInterfaceAttributes(
        request: zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVirtualInterfaceAttributesRequest,
      UpdateVirtualInterfaceAttributesResponse
    ]("updateVirtualInterfaceAttributes", api.updateVirtualInterfaceAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesResponse.wrap
    ).provideEnvironment(r)
    def confirmTransitVirtualInterface(
        request: zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      ConfirmTransitVirtualInterfaceRequest,
      ConfirmTransitVirtualInterfaceResponse
    ]("confirmTransitVirtualInterface", api.confirmTransitVirtualInterface)(
      request.buildAwsValue()
    ).map(
      zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.wrap
    ).provideEnvironment(r)
    def describeVirtualGateways(): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVirtualGatewaysRequest,
      DescribeVirtualGatewaysResponse
    ]("describeVirtualGateways", api.describeVirtualGateways)(
      DescribeVirtualGatewaysRequest.builder().build()
    ).map(zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.wrap)
      .provideEnvironment(r)
    def describeDirectConnectGatewayAssociationProposals(
        request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDirectConnectGatewayAssociationProposalsRequest,
      DescribeDirectConnectGatewayAssociationProposalsResponse
    ](
      "describeDirectConnectGatewayAssociationProposals",
      api.describeDirectConnectGatewayAssociationProposals
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.wrap
      )
      .provideEnvironment(r)
    def describeCustomerMetadata(): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCustomerMetadataRequest,
      DescribeCustomerMetadataResponse
    ]("describeCustomerMetadata", api.describeCustomerMetadata)(
      DescribeCustomerMetadataRequest.builder().build()
    ).map(zio.aws.directconnect.model.DescribeCustomerMetadataResponse.wrap)
      .provideEnvironment(r)
    def describeConnections(
        request: zio.aws.directconnect.model.DescribeConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConnectionsRequest,
      DescribeConnectionsResponse
    ]("describeConnections", api.describeConnections)(request.buildAwsValue())
      .map(zio.aws.directconnect.model.DescribeConnectionsResponse.wrap)
      .provideEnvironment(r)
    def createDirectConnectGatewayAssociation(
        request: zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDirectConnectGatewayAssociationRequest,
      CreateDirectConnectGatewayAssociationResponse
    ](
      "createDirectConnectGatewayAssociation",
      api.createDirectConnectGatewayAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def createInterconnect(
        request: zio.aws.directconnect.model.CreateInterconnectRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateInterconnectResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateInterconnectRequest,
      CreateInterconnectResponse
    ]("createInterconnect", api.createInterconnect)(request.buildAwsValue())
      .map(zio.aws.directconnect.model.CreateInterconnectResponse.wrap)
      .provideEnvironment(r)
    def createDirectConnectGatewayAssociationProposal(
        request: zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDirectConnectGatewayAssociationProposalRequest,
      CreateDirectConnectGatewayAssociationProposalResponse
    ](
      "createDirectConnectGatewayAssociationProposal",
      api.createDirectConnectGatewayAssociationProposal
    )(request.buildAwsValue())
      .map(
        zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.wrap
      )
      .provideEnvironment(r)
    def createLag(
        request: zio.aws.directconnect.model.CreateLagRequest
    ): IO[AwsError, zio.aws.directconnect.model.CreateLagResponse.ReadOnly] =
      asyncRequestResponse[CreateLagRequest, CreateLagResponse](
        "createLag",
        api.createLag
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.CreateLagResponse.wrap)
        .provideEnvironment(r)
    def associateConnectionWithLag(
        request: zio.aws.directconnect.model.AssociateConnectionWithLagRequest
    ): IO[
      AwsError,
      zio.aws.directconnect.model.AssociateConnectionWithLagResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateConnectionWithLagRequest,
      AssociateConnectionWithLagResponse
    ]("associateConnectionWithLag", api.associateConnectionWithLag)(
      request.buildAwsValue()
    ).map(zio.aws.directconnect.model.AssociateConnectionWithLagResponse.wrap)
      .provideEnvironment(r)
    def describeLoa(
        request: zio.aws.directconnect.model.DescribeLoaRequest
    ): IO[AwsError, zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly] =
      asyncRequestResponse[DescribeLoaRequest, DescribeLoaResponse](
        "describeLoa",
        api.describeLoa
      )(request.buildAwsValue())
        .map(zio.aws.directconnect.model.DescribeLoaResponse.wrap)
        .provideEnvironment(r)
  }
  def allocatePrivateVirtualInterface(
      request: zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest
  ): ZIO[zio.aws.directconnect.DirectConnect, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.allocatePrivateVirtualInterface(request))
  def createTransitVirtualInterface(
      request: zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitVirtualInterface(request))
  def describeTags(
      request: zio.aws.directconnect.model.DescribeTagsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTags(request))
  def disassociateMacSecKey(
      request: zio.aws.directconnect.model.DisassociateMacSecKeyRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMacSecKey(request))
  def stopBgpFailoverTest(
      request: zio.aws.directconnect.model.StopBgpFailoverTestRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.StopBgpFailoverTestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopBgpFailoverTest(request))
  def createDirectConnectGateway(
      request: zio.aws.directconnect.model.CreateDirectConnectGatewayRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDirectConnectGateway(request))
  def associateHostedConnection(
      request: zio.aws.directconnect.model.AssociateHostedConnectionRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AssociateHostedConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateHostedConnection(request))
  def describeDirectConnectGatewayAttachments(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDirectConnectGatewayAttachments(request))
  def describeDirectConnectGateways(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDirectConnectGateways(request))
  def associateMacSecKey(
      request: zio.aws.directconnect.model.AssociateMacSecKeyRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMacSecKey(request))
  def listVirtualInterfaceTestHistory(
      request: zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualInterfaceTestHistory(request))
  def disassociateConnectionFromLag(
      request: zio.aws.directconnect.model.DisassociateConnectionFromLagRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DisassociateConnectionFromLagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateConnectionFromLag(request))
  def allocateHostedConnection(
      request: zio.aws.directconnect.model.AllocateHostedConnectionRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocateHostedConnection(request))
  def describeHostedConnections(
      request: zio.aws.directconnect.model.DescribeHostedConnectionsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHostedConnections(request))
  def updateDirectConnectGateway(
      request: zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDirectConnectGateway(request))
  def createConnection(
      request: zio.aws.directconnect.model.CreateConnectionRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnection(request))
  def confirmPublicVirtualInterface(
      request: zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmPublicVirtualInterface(request))
  def startBgpFailoverTest(
      request: zio.aws.directconnect.model.StartBgpFailoverTestRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.StartBgpFailoverTestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startBgpFailoverTest(request))
  def updateConnection(
      request: zio.aws.directconnect.model.UpdateConnectionRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.UpdateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnection(request))
  def deleteDirectConnectGatewayAssociation(
      request: zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDirectConnectGatewayAssociation(request))
  def describeRouterConfiguration(
      request: zio.aws.directconnect.model.DescribeRouterConfigurationRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRouterConfiguration(request))
  def updateLag(request: zio.aws.directconnect.model.UpdateLagRequest): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.UpdateLagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLag(request))
  def deleteBGPPeer(
      request: zio.aws.directconnect.model.DeleteBgpPeerRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteBgpPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBGPPeer(request))
  def confirmCustomerAgreement(
      request: zio.aws.directconnect.model.ConfirmCustomerAgreementRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmCustomerAgreement(request))
  def confirmConnection(
      request: zio.aws.directconnect.model.ConfirmConnectionRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmConnection(request))
  def describeDirectConnectGatewayAssociations(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDirectConnectGatewayAssociations(request))
  def acceptDirectConnectGatewayAssociationProposal(
      request: zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.acceptDirectConnectGatewayAssociationProposal(request))
  def allocatePublicVirtualInterface(
      request: zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AllocatePublicVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocatePublicVirtualInterface(request))
  def deleteVirtualInterface(
      request: zio.aws.directconnect.model.DeleteVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVirtualInterface(request))
  def createPublicVirtualInterface(
      request: zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreatePublicVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPublicVirtualInterface(request))
  def deleteInterconnect(
      request: zio.aws.directconnect.model.DeleteInterconnectRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInterconnect(request))
  def untagResource(
      request: zio.aws.directconnect.model.UntagResourceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteLag(request: zio.aws.directconnect.model.DeleteLagRequest): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteLagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLag(request))
  def describeVirtualInterfaces(
      request: zio.aws.directconnect.model.DescribeVirtualInterfacesRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVirtualInterfaces(request))
  def describeInterconnects(
      request: zio.aws.directconnect.model.DescribeInterconnectsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInterconnects(request))
  def deleteDirectConnectGateway(
      request: zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteDirectConnectGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDirectConnectGateway(request))
  def createPrivateVirtualInterface(
      request: zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreatePrivateVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPrivateVirtualInterface(request))
  def describeLags(
      request: zio.aws.directconnect.model.DescribeLagsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLags(request))
  def describeLocations(): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocations())
  def createBGPPeer(
      request: zio.aws.directconnect.model.CreateBgpPeerRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateBgpPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBGPPeer(request))
  def allocateTransitVirtualInterface(
      request: zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocateTransitVirtualInterface(request))
  def associateVirtualInterface(
      request: zio.aws.directconnect.model.AssociateVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateVirtualInterface(request))
  def confirmPrivateVirtualInterface(
      request: zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmPrivateVirtualInterface(request))
  def updateDirectConnectGatewayAssociation(
      request: zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDirectConnectGatewayAssociation(request))
  def deleteConnection(
      request: zio.aws.directconnect.model.DeleteConnectionRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def tagResource(request: zio.aws.directconnect.model.TagResourceRequest): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteDirectConnectGatewayAssociationProposal(
      request: zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deleteDirectConnectGatewayAssociationProposal(request))
  def updateVirtualInterfaceAttributes(
      request: zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVirtualInterfaceAttributes(request))
  def confirmTransitVirtualInterface(
      request: zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmTransitVirtualInterface(request))
  def describeVirtualGateways(): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVirtualGateways())
  def describeDirectConnectGatewayAssociationProposals(
      request: zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeDirectConnectGatewayAssociationProposals(request)
  )
  def describeCustomerMetadata(): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomerMetadata())
  def describeConnections(
      request: zio.aws.directconnect.model.DescribeConnectionsRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnections(request))
  def createDirectConnectGatewayAssociation(
      request: zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDirectConnectGatewayAssociation(request))
  def createInterconnect(
      request: zio.aws.directconnect.model.CreateInterconnectRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateInterconnectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInterconnect(request))
  def createDirectConnectGatewayAssociationProposal(
      request: zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.createDirectConnectGatewayAssociationProposal(request))
  def createLag(request: zio.aws.directconnect.model.CreateLagRequest): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.CreateLagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLag(request))
  def associateConnectionWithLag(
      request: zio.aws.directconnect.model.AssociateConnectionWithLagRequest
  ): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.AssociateConnectionWithLagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateConnectionWithLag(request))
  def describeLoa(request: zio.aws.directconnect.model.DescribeLoaRequest): ZIO[
    zio.aws.directconnect.DirectConnect,
    AwsError,
    zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoa(request))
}
