package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  AnomalyDescription,
  Timestamp,
  AnomalyLimit,
  AnomalyId,
  InsightId
}
import scala.jdk.CollectionConverters.*
final case class ProactiveAnomaly(
    id: Optional[AnomalyId] = Optional.Absent,
    severity: Optional[zio.aws.devopsguru.model.AnomalySeverity] =
      Optional.Absent,
    status: Optional[zio.aws.devopsguru.model.AnomalyStatus] = Optional.Absent,
    updateTime: Optional[Timestamp] = Optional.Absent,
    anomalyTimeRange: Optional[zio.aws.devopsguru.model.AnomalyTimeRange] =
      Optional.Absent,
    anomalyReportedTimeRange: Optional[
      zio.aws.devopsguru.model.AnomalyReportedTimeRange
    ] = Optional.Absent,
    predictionTimeRange: Optional[
      zio.aws.devopsguru.model.PredictionTimeRange
    ] = Optional.Absent,
    sourceDetails: Optional[zio.aws.devopsguru.model.AnomalySourceDetails] =
      Optional.Absent,
    associatedInsightId: Optional[InsightId] = Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    limit: Optional[AnomalyLimit] = Optional.Absent,
    sourceMetadata: Optional[zio.aws.devopsguru.model.AnomalySourceMetadata] =
      Optional.Absent,
    anomalyResources: Optional[
      Iterable[zio.aws.devopsguru.model.AnomalyResource]
    ] = Optional.Absent,
    description: Optional[AnomalyDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaly = {
    import ProactiveAnomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaly
      .builder()
      .optionallyWith(
        id.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateTime)
      .optionallyWith(anomalyTimeRange.map(value => value.buildAwsValue()))(
        _.anomalyTimeRange
      )
      .optionallyWith(
        anomalyReportedTimeRange.map(value => value.buildAwsValue())
      )(_.anomalyReportedTimeRange)
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(sourceDetails.map(value => value.buildAwsValue()))(
        _.sourceDetails
      )
      .optionallyWith(
        associatedInsightId.map(value =>
          InsightId.unwrap(value): java.lang.String
        )
      )(_.associatedInsightId)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(
        limit.map(value => AnomalyLimit.unwrap(value): java.lang.Double)
      )(_.limit)
      .optionallyWith(sourceMetadata.map(value => value.buildAwsValue()))(
        _.sourceMetadata
      )
      .optionallyWith(
        anomalyResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalyResources)
      .optionallyWith(
        description.map(value =>
          AnomalyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ProactiveAnomaly.ReadOnly =
    zio.aws.devopsguru.model.ProactiveAnomaly.wrap(buildAwsValue())
}
object ProactiveAnomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ProactiveAnomaly =
      zio.aws.devopsguru.model.ProactiveAnomaly(
        id.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        updateTime.map(value => value),
        anomalyTimeRange.map(value => value.asEditable),
        anomalyReportedTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        sourceDetails.map(value => value.asEditable),
        associatedInsightId.map(value => value),
        resourceCollection.map(value => value.asEditable),
        limit.map(value => value),
        sourceMetadata.map(value => value.asEditable),
        anomalyResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value)
      )
    def id: Optional[AnomalyId]
    def severity: Optional[zio.aws.devopsguru.model.AnomalySeverity]
    def status: Optional[zio.aws.devopsguru.model.AnomalyStatus]
    def updateTime: Optional[Timestamp]
    def anomalyTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly]
    def anomalyReportedTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly]
    def predictionTimeRange
        : Optional[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def sourceDetails
        : Optional[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly]
    def associatedInsightId: Optional[InsightId]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def limit: Optional[AnomalyLimit]
    def sourceMetadata
        : Optional[zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly]
    def anomalyResources
        : Optional[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]]
    def description: Optional[AnomalyDescription]
    def getId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("id", id)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalySeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateTime", updateTime)
    def getAnomalyTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("anomalyTimeRange", anomalyTimeRange)
    def getAnomalyReportedTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "anomalyReportedTimeRange",
      anomalyReportedTimeRange
    )
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getSourceDetails: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getAssociatedInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("associatedInsightId", associatedInsightId)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getLimit: ZIO[Any, AwsError, AnomalyLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getSourceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("sourceMetadata", sourceMetadata)
    def getAnomalyResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.AnomalyResource.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalyResources", anomalyResources)
    def getDescription: ZIO[Any, AwsError, AnomalyDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaly
  ) extends zio.aws.devopsguru.model.ProactiveAnomaly.ReadOnly {
    override val id: Optional[AnomalyId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
    override val severity: Optional[zio.aws.devopsguru.model.AnomalySeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.devopsguru.model.AnomalySeverity.wrap(value))
    override val status: Optional[zio.aws.devopsguru.model.AnomalyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devopsguru.model.AnomalyStatus.wrap(value))
    override val updateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val anomalyTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyTimeRange())
        .map(value => zio.aws.devopsguru.model.AnomalyTimeRange.wrap(value))
    override val anomalyReportedTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyReportedTimeRange())
        .map(value =>
          zio.aws.devopsguru.model.AnomalyReportedTimeRange.wrap(value)
        )
    override val predictionTimeRange
        : Optional[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionTimeRange())
        .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val sourceDetails
        : Optional[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDetails())
        .map(value => zio.aws.devopsguru.model.AnomalySourceDetails.wrap(value))
    override val associatedInsightId: Optional[InsightId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedInsightId())
        .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val limit: Optional[AnomalyLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyLimit(value))
    override val sourceMetadata
        : Optional[zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceMetadata())
        .map(value =>
          zio.aws.devopsguru.model.AnomalySourceMetadata.wrap(value)
        )
    override val anomalyResources
        : Optional[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.AnomalyResource.wrap(item)
          }.toList
        )
    override val description: Optional[AnomalyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.devopsguru.model.primitives.AnomalyDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaly
  ): zio.aws.devopsguru.model.ProactiveAnomaly.ReadOnly = new Wrapper(impl)
}
