package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  AwsAccountId,
  UuidNextToken,
  ListAnomaliesForInsightMaxResults,
  InsightId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAnomaliesForInsightRequest(
    insightId: InsightId,
    startTimeRange: Optional[zio.aws.devopsguru.model.StartTimeRange] =
      Optional.Absent,
    maxResults: Optional[ListAnomaliesForInsightMaxResults] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent,
    accountId: Optional[AwsAccountId] = Optional.Absent,
    filters: Optional[zio.aws.devopsguru.model.ListAnomaliesForInsightFilters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest = {
    import ListAnomaliesForInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .optionallyWith(startTimeRange.map(value => value.buildAwsValue()))(
        _.startTimeRange
      )
      .optionallyWith(
        maxResults.map(value =>
          ListAnomaliesForInsightMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListAnomaliesForInsightRequest.ReadOnly =
    zio.aws.devopsguru.model.ListAnomaliesForInsightRequest
      .wrap(buildAwsValue())
}
object ListAnomaliesForInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListAnomaliesForInsightRequest =
      zio.aws.devopsguru.model.ListAnomaliesForInsightRequest(
        insightId,
        startTimeRange.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        accountId.map(value => value),
        filters.map(value => value.asEditable)
      )
    def insightId: InsightId
    def startTimeRange
        : Optional[zio.aws.devopsguru.model.StartTimeRange.ReadOnly]
    def maxResults: Optional[ListAnomaliesForInsightMaxResults]
    def nextToken: Optional[UuidNextToken]
    def accountId: Optional[AwsAccountId]
    def filters: Optional[
      zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.ReadOnly
    ]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getStartTimeRange
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.StartTimeRange.ReadOnly] =
      AwsError.unwrapOptionField("startTimeRange", startTimeRange)
    def getMaxResults: ZIO[Any, AwsError, ListAnomaliesForInsightMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
  ) extends zio.aws.devopsguru.model.ListAnomaliesForInsightRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.insightId())
    override val startTimeRange
        : Optional[zio.aws.devopsguru.model.StartTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeRange())
        .map(value => zio.aws.devopsguru.model.StartTimeRange.wrap(value))
    override val maxResults: Optional[ListAnomaliesForInsightMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .ListAnomaliesForInsightMaxResults(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val accountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
    override val filters: Optional[
      zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
  ): zio.aws.devopsguru.model.ListAnomaliesForInsightRequest.ReadOnly =
    new Wrapper(impl)
}
