package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.AnalyzedResourceCount
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceHealth(
    serviceName: Optional[zio.aws.devopsguru.model.ServiceName] =
      Optional.Absent,
    insight: Optional[zio.aws.devopsguru.model.ServiceInsightHealth] =
      Optional.Absent,
    analyzedResourceCount: Optional[AnalyzedResourceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ServiceHealth = {
    import ServiceHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ServiceHealth
      .builder()
      .optionallyWith(serviceName.map(value => value.unwrap))(_.serviceName)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .optionallyWith(
        analyzedResourceCount.map(value =>
          AnalyzedResourceCount.unwrap(value): java.lang.Long
        )
      )(_.analyzedResourceCount)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ServiceHealth.ReadOnly =
    zio.aws.devopsguru.model.ServiceHealth.wrap(buildAwsValue())
}
object ServiceHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ServiceHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ServiceHealth =
      zio.aws.devopsguru.model.ServiceHealth(
        serviceName.map(value => value),
        insight.map(value => value.asEditable),
        analyzedResourceCount.map(value => value)
      )
    def serviceName: Optional[zio.aws.devopsguru.model.ServiceName]
    def insight
        : Optional[zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly]
    def analyzedResourceCount: Optional[AnalyzedResourceCount]
    def getServiceName
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getInsight: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly
    ] = AwsError.unwrapOptionField("insight", insight)
    def getAnalyzedResourceCount: ZIO[Any, AwsError, AnalyzedResourceCount] =
      AwsError.unwrapOptionField("analyzedResourceCount", analyzedResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceHealth
  ) extends zio.aws.devopsguru.model.ServiceHealth.ReadOnly {
    override val serviceName: Optional[zio.aws.devopsguru.model.ServiceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceName())
        .map(value => zio.aws.devopsguru.model.ServiceName.wrap(value))
    override val insight
        : Optional[zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insight())
        .map(value => zio.aws.devopsguru.model.ServiceInsightHealth.wrap(value))
    override val analyzedResourceCount: Optional[AnalyzedResourceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzedResourceCount())
        .map(value =>
          zio.aws.devopsguru.model.primitives.AnalyzedResourceCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceHealth
  ): zio.aws.devopsguru.model.ServiceHealth.ReadOnly = new Wrapper(impl)
}
