package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceIntegrationConfig(
    opsCenter: Optional[zio.aws.devopsguru.model.OpsCenterIntegration] =
      Optional.Absent,
    logsAnomalyDetection: Optional[
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ServiceIntegrationConfig = {
    import ServiceIntegrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ServiceIntegrationConfig
      .builder()
      .optionallyWith(opsCenter.map(value => value.buildAwsValue()))(
        _.opsCenter
      )
      .optionallyWith(logsAnomalyDetection.map(value => value.buildAwsValue()))(
        _.logsAnomalyDetection
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ServiceIntegrationConfig.ReadOnly =
    zio.aws.devopsguru.model.ServiceIntegrationConfig.wrap(buildAwsValue())
}
object ServiceIntegrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ServiceIntegrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ServiceIntegrationConfig =
      zio.aws.devopsguru.model.ServiceIntegrationConfig(
        opsCenter.map(value => value.asEditable),
        logsAnomalyDetection.map(value => value.asEditable)
      )
    def opsCenter
        : Optional[zio.aws.devopsguru.model.OpsCenterIntegration.ReadOnly]
    def logsAnomalyDetection: Optional[
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegration.ReadOnly
    ]
    def getOpsCenter: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.OpsCenterIntegration.ReadOnly
    ] = AwsError.unwrapOptionField("opsCenter", opsCenter)
    def getLogsAnomalyDetection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegration.ReadOnly
    ] = AwsError.unwrapOptionField("logsAnomalyDetection", logsAnomalyDetection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceIntegrationConfig
  ) extends zio.aws.devopsguru.model.ServiceIntegrationConfig.ReadOnly {
    override val opsCenter
        : Optional[zio.aws.devopsguru.model.OpsCenterIntegration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsCenter())
        .map(value => zio.aws.devopsguru.model.OpsCenterIntegration.wrap(value))
    override val logsAnomalyDetection: Optional[
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logsAnomalyDetection())
      .map(value =>
        zio.aws.devopsguru.model.LogsAnomalyDetectionIntegration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceIntegrationConfig
  ): zio.aws.devopsguru.model.ServiceIntegrationConfig.ReadOnly = new Wrapper(
    impl
  )
}
