package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait CloudWatchMetricsStat {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat
}
object CloudWatchMetricsStat {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat
  ): zio.aws.devopsguru.model.CloudWatchMetricsStat = value match {
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.SUM =>
      val r = Sum
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.SAMPLE_COUNT =>
      val r = SampleCount
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.P99 =>
      val r = p99
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.P90 =>
      val r = p90
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.P50 =>
      val r = p50
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.UNKNOWN_TO_SDK_VERSION
  }
  case object Sum extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.SUM
  }
  case object Average extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.AVERAGE
  }
  case object SampleCount
      extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.SAMPLE_COUNT
  }
  case object Minimum extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.MINIMUM
  }
  case object Maximum extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.MAXIMUM
  }
  case object p99 extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.P99
  }
  case object p90 extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.P90
  }
  case object p50 extends zio.aws.devopsguru.model.CloudWatchMetricsStat {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat.P50
  }
}
