package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  ListMonitoredResourcesMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMonitoredResourcesRequest(
    filters: Optional[zio.aws.devopsguru.model.ListMonitoredResourcesFilters] =
      Optional.Absent,
    maxResults: Optional[ListMonitoredResourcesMaxResults] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest = {
    import ListMonitoredResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          ListMonitoredResourcesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListMonitoredResourcesRequest.ReadOnly =
    zio.aws.devopsguru.model.ListMonitoredResourcesRequest.wrap(buildAwsValue())
}
object ListMonitoredResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListMonitoredResourcesRequest =
      zio.aws.devopsguru.model.ListMonitoredResourcesRequest(
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[
      zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly
    ]
    def maxResults: Optional[ListMonitoredResourcesMaxResults]
    def nextToken: Optional[UuidNextToken]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, ListMonitoredResourcesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
  ) extends zio.aws.devopsguru.model.ListMonitoredResourcesRequest.ReadOnly {
    override val filters: Optional[
      zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.devopsguru.model.ListMonitoredResourcesFilters.wrap(value)
      )
    override val maxResults: Optional[ListMonitoredResourcesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .ListMonitoredResourcesMaxResults(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
  ): zio.aws.devopsguru.model.ListMonitoredResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
