package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsValueDouble,
  PerformanceInsightsStatType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PerformanceInsightsStat(
    `type`: Optional[PerformanceInsightsStatType] = Optional.Absent,
    value: Optional[PerformanceInsightsValueDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStat = {
    import PerformanceInsightsStat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStat
      .builder()
      .optionallyWith(
        `type`.map(value =>
          PerformanceInsightsStatType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .optionallyWith(
        value.map(value =>
          PerformanceInsightsValueDouble.unwrap(value): java.lang.Double
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsStat.wrap(buildAwsValue())
}
object PerformanceInsightsStat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PerformanceInsightsStat =
      zio.aws.devopsguru.model.PerformanceInsightsStat(
        `type`.map(value => value),
        value.map(value => value)
      )
    def `type`: Optional[PerformanceInsightsStatType]
    def value: Optional[PerformanceInsightsValueDouble]
    def getType: ZIO[Any, AwsError, PerformanceInsightsStatType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, PerformanceInsightsValueDouble] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStat
  ) extends zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly {
    override val `type`: Optional[PerformanceInsightsStatType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.devopsguru.model.primitives.PerformanceInsightsStatType(value)
        )
    override val value: Optional[PerformanceInsightsValueDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .PerformanceInsightsValueDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStat
  ): zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly = new Wrapper(
    impl
  )
}
