package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFeedbackResponse(
    insightFeedback: Optional[zio.aws.devopsguru.model.InsightFeedback] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse = {
    import DescribeFeedbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse
      .builder()
      .optionallyWith(insightFeedback.map(value => value.buildAwsValue()))(
        _.insightFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeFeedbackResponse.wrap(buildAwsValue())
}
object DescribeFeedbackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeFeedbackResponse =
      zio.aws.devopsguru.model.DescribeFeedbackResponse(
        insightFeedback.map(value => value.asEditable)
      )
    def insightFeedback
        : Optional[zio.aws.devopsguru.model.InsightFeedback.ReadOnly]
    def getInsightFeedback: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightFeedback.ReadOnly
    ] = AwsError.unwrapOptionField("insightFeedback", insightFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse
  ) extends zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly {
    override val insightFeedback
        : Optional[zio.aws.devopsguru.model.InsightFeedback.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightFeedback())
        .map(value => zio.aws.devopsguru.model.InsightFeedback.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse
  ): zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly = new Wrapper(
    impl
  )
}
