package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceTypeFilter {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter
}
object ResourceTypeFilter {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter
  ): zio.aws.devopsguru.model.ResourceTypeFilter = value match {
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.LOG_GROUPS =>
      val r = LOG_GROUPS
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.CLOUDFRONT_DISTRIBUTION =>
      val r = CLOUDFRONT_DISTRIBUTION
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.DYNAMODB_TABLE =>
      val r = DYNAMODB_TABLE
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.EC2_NAT_GATEWAY =>
      val r = EC2_NAT_GATEWAY
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ECS_CLUSTER =>
      val r = ECS_CLUSTER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ECS_SERVICE =>
      val r = ECS_SERVICE
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.EKS_CLUSTER =>
      val r = EKS_CLUSTER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_BEANSTALK_ENVIRONMENT =>
      val r = ELASTIC_BEANSTALK_ENVIRONMENT
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_LOAD_BALANCER_LOAD_BALANCER =>
      val r = ELASTIC_LOAD_BALANCER_LOAD_BALANCER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER =>
      val r = ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP =>
      val r = ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTICACHE_CACHE_CLUSTER =>
      val r = ELASTICACHE_CACHE_CLUSTER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTICSEARCH_DOMAIN =>
      val r = ELASTICSEARCH_DOMAIN
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.KINESIS_STREAM =>
      val r = KINESIS_STREAM
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.LAMBDA_FUNCTION =>
      val r = LAMBDA_FUNCTION
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.OPEN_SEARCH_SERVICE_DOMAIN =>
      val r = OPEN_SEARCH_SERVICE_DOMAIN
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.RDS_DB_INSTANCE =>
      val r = RDS_DB_INSTANCE
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.RDS_DB_CLUSTER =>
      val r = RDS_DB_CLUSTER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.REDSHIFT_CLUSTER =>
      val r = REDSHIFT_CLUSTER
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ROUTE53_HOSTED_ZONE =>
      val r = ROUTE53_HOSTED_ZONE
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ROUTE53_HEALTH_CHECK =>
      val r = ROUTE53_HEALTH_CHECK
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.S3_BUCKET =>
      val r = S3_BUCKET
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.SAGEMAKER_ENDPOINT =>
      val r = SAGEMAKER_ENDPOINT
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.SNS_TOPIC =>
      val r = SNS_TOPIC
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.SQS_QUEUE =>
      val r = SQS_QUEUE
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.STEP_FUNCTIONS_ACTIVITY =>
      val r = STEP_FUNCTIONS_ACTIVITY
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.STEP_FUNCTIONS_STATE_MACHINE =>
      val r = STEP_FUNCTIONS_STATE_MACHINE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object LOG_GROUPS extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.LOG_GROUPS
  }
  case object CLOUDFRONT_DISTRIBUTION
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.CLOUDFRONT_DISTRIBUTION
  }
  case object DYNAMODB_TABLE
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.DYNAMODB_TABLE
  }
  case object EC2_NAT_GATEWAY
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.EC2_NAT_GATEWAY
  }
  case object ECS_CLUSTER extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ECS_CLUSTER
  }
  case object ECS_SERVICE extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ECS_SERVICE
  }
  case object EKS_CLUSTER extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.EKS_CLUSTER
  }
  case object ELASTIC_BEANSTALK_ENVIRONMENT
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_BEANSTALK_ENVIRONMENT
  }
  case object ELASTIC_LOAD_BALANCER_LOAD_BALANCER
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_LOAD_BALANCER_LOAD_BALANCER
  }
  case object ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER
  }
  case object ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP
  }
  case object ELASTICACHE_CACHE_CLUSTER
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTICACHE_CACHE_CLUSTER
  }
  case object ELASTICSEARCH_DOMAIN
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ELASTICSEARCH_DOMAIN
  }
  case object KINESIS_STREAM
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.KINESIS_STREAM
  }
  case object LAMBDA_FUNCTION
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.LAMBDA_FUNCTION
  }
  case object OPEN_SEARCH_SERVICE_DOMAIN
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.OPEN_SEARCH_SERVICE_DOMAIN
  }
  case object RDS_DB_INSTANCE
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.RDS_DB_INSTANCE
  }
  case object RDS_DB_CLUSTER
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.RDS_DB_CLUSTER
  }
  case object REDSHIFT_CLUSTER
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.REDSHIFT_CLUSTER
  }
  case object ROUTE53_HOSTED_ZONE
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ROUTE53_HOSTED_ZONE
  }
  case object ROUTE53_HEALTH_CHECK
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.ROUTE53_HEALTH_CHECK
  }
  case object S3_BUCKET extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.S3_BUCKET
  }
  case object SAGEMAKER_ENDPOINT
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.SAGEMAKER_ENDPOINT
  }
  case object SNS_TOPIC extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.SNS_TOPIC
  }
  case object SQS_QUEUE extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.SQS_QUEUE
  }
  case object STEP_FUNCTIONS_ACTIVITY
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.STEP_FUNCTIONS_ACTIVITY
  }
  case object STEP_FUNCTIONS_STATE_MACHINE
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.STEP_FUNCTIONS_STATE_MACHINE
  }
}
