package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationFilterConfig(
    severities: Optional[Iterable[zio.aws.devopsguru.model.InsightSeverity]] =
      Optional.Absent,
    messageTypes: Optional[
      Iterable[zio.aws.devopsguru.model.NotificationMessageType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.NotificationFilterConfig = {
    import NotificationFilterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.NotificationFilterConfig
      .builder()
      .optionallyWith(
        severities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.severitiesWithStrings)
      .optionallyWith(
        messageTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.messageTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.NotificationFilterConfig.ReadOnly =
    zio.aws.devopsguru.model.NotificationFilterConfig.wrap(buildAwsValue())
}
object NotificationFilterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.NotificationFilterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.NotificationFilterConfig =
      zio.aws.devopsguru.model.NotificationFilterConfig(
        severities.map(value => value),
        messageTypes.map(value => value)
      )
    def severities: Optional[List[zio.aws.devopsguru.model.InsightSeverity]]
    def messageTypes
        : Optional[List[zio.aws.devopsguru.model.NotificationMessageType]]
    def getSeverities
        : ZIO[Any, AwsError, List[zio.aws.devopsguru.model.InsightSeverity]] =
      AwsError.unwrapOptionField("severities", severities)
    def getMessageTypes: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.NotificationMessageType
    ]] = AwsError.unwrapOptionField("messageTypes", messageTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationFilterConfig
  ) extends zio.aws.devopsguru.model.NotificationFilterConfig.ReadOnly {
    override val severities
        : Optional[List[zio.aws.devopsguru.model.InsightSeverity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.InsightSeverity.wrap(item)
          }.toList
        )
    override val messageTypes
        : Optional[List[zio.aws.devopsguru.model.NotificationMessageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.NotificationMessageType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationFilterConfig
  ): zio.aws.devopsguru.model.NotificationFilterConfig.ReadOnly = new Wrapper(
    impl
  )
}
