package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait AnomalyType {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.AnomalyType
}
object AnomalyType {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.AnomalyType
  ): zio.aws.devopsguru.model.AnomalyType = value match {
    case software.amazon.awssdk.services.devopsguru.model.AnomalyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.AnomalyType.CAUSAL =>
      val r = CAUSAL
      r
    case software.amazon.awssdk.services.devopsguru.model.AnomalyType.CONTEXTUAL =>
      val r = CONTEXTUAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.devopsguru.model.AnomalyType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.AnomalyType =
      software.amazon.awssdk.services.devopsguru.model.AnomalyType.UNKNOWN_TO_SDK_VERSION
  }
  case object CAUSAL extends zio.aws.devopsguru.model.AnomalyType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.AnomalyType =
      software.amazon.awssdk.services.devopsguru.model.AnomalyType.CAUSAL
  }
  case object CONTEXTUAL extends zio.aws.devopsguru.model.AnomalyType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.AnomalyType =
      software.amazon.awssdk.services.devopsguru.model.AnomalyType.CONTEXTUAL
  }
}
