package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchOrganizationInsightsFilters(
    severities: Optional[Iterable[zio.aws.devopsguru.model.InsightSeverity]] =
      Optional.Absent,
    statuses: Optional[Iterable[zio.aws.devopsguru.model.InsightStatus]] =
      Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    serviceCollection: Optional[zio.aws.devopsguru.model.ServiceCollection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsFilters = {
    import SearchOrganizationInsightsFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsFilters
      .builder()
      .optionallyWith(
        severities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.severitiesWithStrings)
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusesWithStrings)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.ReadOnly =
    zio.aws.devopsguru.model.SearchOrganizationInsightsFilters
      .wrap(buildAwsValue())
}
object SearchOrganizationInsightsFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.SearchOrganizationInsightsFilters =
      zio.aws.devopsguru.model.SearchOrganizationInsightsFilters(
        severities.map(value => value),
        statuses.map(value => value),
        resourceCollection.map(value => value.asEditable),
        serviceCollection.map(value => value.asEditable)
      )
    def severities: Optional[List[zio.aws.devopsguru.model.InsightSeverity]]
    def statuses: Optional[List[zio.aws.devopsguru.model.InsightStatus]]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def getSeverities
        : ZIO[Any, AwsError, List[zio.aws.devopsguru.model.InsightSeverity]] =
      AwsError.unwrapOptionField("severities", severities)
    def getStatuses
        : ZIO[Any, AwsError, List[zio.aws.devopsguru.model.InsightStatus]] =
      AwsError.unwrapOptionField("statuses", statuses)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsFilters
  ) extends zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.ReadOnly {
    override val severities
        : Optional[List[zio.aws.devopsguru.model.InsightSeverity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.InsightSeverity.wrap(item)
          }.toList
        )
    override val statuses
        : Optional[List[zio.aws.devopsguru.model.InsightStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.InsightStatus.wrap(item)
          }.toList
        )
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCollection())
        .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsFilters
  ): zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.ReadOnly =
    new Wrapper(impl)
}
