package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait EventDataSource {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.EventDataSource
}
object EventDataSource {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.EventDataSource
  ): zio.aws.devopsguru.model.EventDataSource = value match {
    case software.amazon.awssdk.services.devopsguru.model.EventDataSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.EventDataSource.AWS_CLOUD_TRAIL =>
      val r = AWS_CLOUD_TRAIL
      r
    case software.amazon.awssdk.services.devopsguru.model.EventDataSource.AWS_CODE_DEPLOY =>
      val r = AWS_CODE_DEPLOY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.EventDataSource {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventDataSource =
      software.amazon.awssdk.services.devopsguru.model.EventDataSource.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_CLOUD_TRAIL extends zio.aws.devopsguru.model.EventDataSource {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventDataSource =
      software.amazon.awssdk.services.devopsguru.model.EventDataSource.AWS_CLOUD_TRAIL
  }
  case object AWS_CODE_DEPLOY extends zio.aws.devopsguru.model.EventDataSource {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventDataSource =
      software.amazon.awssdk.services.devopsguru.model.EventDataSource.AWS_CODE_DEPLOY
  }
}
