package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceCollection(
    cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCollection
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.devopsguru.model.TagCollection]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ResourceCollection = {
    import ResourceCollection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ResourceCollection
      .builder()
      .optionallyWith(cloudFormation.map(value => value.buildAwsValue()))(
        _.cloudFormation
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ResourceCollection.ReadOnly =
    zio.aws.devopsguru.model.ResourceCollection.wrap(buildAwsValue())
}
object ResourceCollection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ResourceCollection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ResourceCollection =
      zio.aws.devopsguru.model.ResourceCollection(
        cloudFormation.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudFormation
        : Optional[zio.aws.devopsguru.model.CloudFormationCollection.ReadOnly]
    def tags: Optional[List[zio.aws.devopsguru.model.TagCollection.ReadOnly]]
    def getCloudFormation: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudFormationCollection.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.TagCollection.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ResourceCollection
  ) extends zio.aws.devopsguru.model.ResourceCollection.ReadOnly {
    override val cloudFormation
        : Optional[zio.aws.devopsguru.model.CloudFormationCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudFormation())
        .map(value =>
          zio.aws.devopsguru.model.CloudFormationCollection.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.devopsguru.model.TagCollection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.TagCollection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ResourceCollection
  ): zio.aws.devopsguru.model.ResourceCollection.ReadOnly = new Wrapper(impl)
}
