package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  ResourceHours,
  NumMetricsAnalyzed,
  NumOpenProactiveInsights,
  AnalyzedResourceCount,
  NumOpenReactiveInsights
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeAccountHealthResponse(
    openReactiveInsights: NumOpenReactiveInsights,
    openProactiveInsights: NumOpenProactiveInsights,
    metricsAnalyzed: NumMetricsAnalyzed,
    resourceHours: ResourceHours,
    analyzedResourceCount: Optional[AnalyzedResourceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse = {
    import DescribeAccountHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
      .builder()
      .openReactiveInsights(
        NumOpenReactiveInsights.unwrap(openReactiveInsights): Integer
      )
      .openProactiveInsights(
        NumOpenProactiveInsights.unwrap(openProactiveInsights): Integer
      )
      .metricsAnalyzed(NumMetricsAnalyzed.unwrap(metricsAnalyzed): Integer)
      .resourceHours(ResourceHours.unwrap(resourceHours): java.lang.Long)
      .optionallyWith(
        analyzedResourceCount.map(value =>
          AnalyzedResourceCount.unwrap(value): java.lang.Long
        )
      )(_.analyzedResourceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeAccountHealthResponse.wrap(buildAwsValue())
}
object DescribeAccountHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeAccountHealthResponse =
      zio.aws.devopsguru.model.DescribeAccountHealthResponse(
        openReactiveInsights,
        openProactiveInsights,
        metricsAnalyzed,
        resourceHours,
        analyzedResourceCount.map(value => value)
      )
    def openReactiveInsights: NumOpenReactiveInsights
    def openProactiveInsights: NumOpenProactiveInsights
    def metricsAnalyzed: NumMetricsAnalyzed
    def resourceHours: ResourceHours
    def analyzedResourceCount: Optional[AnalyzedResourceCount]
    def getOpenReactiveInsights: ZIO[Any, Nothing, NumOpenReactiveInsights] =
      ZIO.succeed(openReactiveInsights)
    def getOpenProactiveInsights: ZIO[Any, Nothing, NumOpenProactiveInsights] =
      ZIO.succeed(openProactiveInsights)
    def getMetricsAnalyzed: ZIO[Any, Nothing, NumMetricsAnalyzed] =
      ZIO.succeed(metricsAnalyzed)
    def getResourceHours: ZIO[Any, Nothing, ResourceHours] =
      ZIO.succeed(resourceHours)
    def getAnalyzedResourceCount: ZIO[Any, AwsError, AnalyzedResourceCount] =
      AwsError.unwrapOptionField("analyzedResourceCount", analyzedResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
  ) extends zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly {
    override val openReactiveInsights: NumOpenReactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumOpenReactiveInsights(impl.openReactiveInsights())
    override val openProactiveInsights: NumOpenProactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumOpenProactiveInsights(impl.openProactiveInsights())
    override val metricsAnalyzed: NumMetricsAnalyzed =
      zio.aws.devopsguru.model.primitives
        .NumMetricsAnalyzed(impl.metricsAnalyzed())
    override val resourceHours: ResourceHours =
      zio.aws.devopsguru.model.primitives.ResourceHours(impl.resourceHours())
    override val analyzedResourceCount: Optional[AnalyzedResourceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzedResourceCount())
        .map(value =>
          zio.aws.devopsguru.model.primitives.AnalyzedResourceCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
  ): zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly =
    new Wrapper(impl)
}
