package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationChannelConfig(
    sns: zio.aws.devopsguru.model.SnsChannelConfig,
    filters: Optional[zio.aws.devopsguru.model.NotificationFilterConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig = {
    import NotificationChannelConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
      .builder()
      .sns(sns.buildAwsValue())
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly =
    zio.aws.devopsguru.model.NotificationChannelConfig.wrap(buildAwsValue())
}
object NotificationChannelConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.NotificationChannelConfig =
      zio.aws.devopsguru.model.NotificationChannelConfig(
        sns.asEditable,
        filters.map(value => value.asEditable)
      )
    def sns: zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly
    def filters
        : Optional[zio.aws.devopsguru.model.NotificationFilterConfig.ReadOnly]
    def getSns: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly
    ] = ZIO.succeed(sns)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.NotificationFilterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
  ) extends zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly {
    override val sns: zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly =
      zio.aws.devopsguru.model.SnsChannelConfig.wrap(impl.sns())
    override val filters
        : Optional[zio.aws.devopsguru.model.NotificationFilterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          zio.aws.devopsguru.model.NotificationFilterConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
  ): zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly = new Wrapper(
    impl
  )
}
