package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationMessageType {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType
}
object NotificationMessageType {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.NotificationMessageType
  ): zio.aws.devopsguru.model.NotificationMessageType = value match {
    case software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.NEW_INSIGHT =>
      val r = NEW_INSIGHT
      r
    case software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.CLOSED_INSIGHT =>
      val r = CLOSED_INSIGHT
      r
    case software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.NEW_ASSOCIATION =>
      val r = NEW_ASSOCIATION
      r
    case software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.SEVERITY_UPGRADED =>
      val r = SEVERITY_UPGRADED
      r
    case software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.NEW_RECOMMENDATION =>
      val r = NEW_RECOMMENDATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.NotificationMessageType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType =
      software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW_INSIGHT
      extends zio.aws.devopsguru.model.NotificationMessageType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType =
      software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.NEW_INSIGHT
  }
  case object CLOSED_INSIGHT
      extends zio.aws.devopsguru.model.NotificationMessageType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType =
      software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.CLOSED_INSIGHT
  }
  case object NEW_ASSOCIATION
      extends zio.aws.devopsguru.model.NotificationMessageType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType =
      software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.NEW_ASSOCIATION
  }
  case object SEVERITY_UPGRADED
      extends zio.aws.devopsguru.model.NotificationMessageType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType =
      software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.SEVERITY_UPGRADED
  }
  case object NEW_RECOMMENDATION
      extends zio.aws.devopsguru.model.NotificationMessageType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.NotificationMessageType =
      software.amazon.awssdk.services.devopsguru.model.NotificationMessageType.NEW_RECOMMENDATION
  }
}
