package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationResourceCollectionHealthResponse(
    cloudFormation: Optional[
      Iterable[zio.aws.devopsguru.model.CloudFormationHealth]
    ] = Optional.Absent,
    service: Optional[Iterable[zio.aws.devopsguru.model.ServiceHealth]] =
      Optional.Absent,
    account: Optional[Iterable[zio.aws.devopsguru.model.AccountHealth]] =
      Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.devopsguru.model.TagHealth]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse = {
    import DescribeOrganizationResourceCollectionHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
      .builder()
      .optionallyWith(
        cloudFormation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudFormation)
      .optionallyWith(
        service.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.service)
      .optionallyWith(
        account.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.account)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationResourceCollectionHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse =
      zio.aws.devopsguru.model
        .DescribeOrganizationResourceCollectionHealthResponse(
          cloudFormation.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          service.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          account.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value),
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def cloudFormation
        : Optional[List[zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly]]
    def service: Optional[List[zio.aws.devopsguru.model.ServiceHealth.ReadOnly]]
    def account: Optional[List[zio.aws.devopsguru.model.AccountHealth.ReadOnly]]
    def nextToken: Optional[UuidNextToken]
    def tags: Optional[List[zio.aws.devopsguru.model.TagHealth.ReadOnly]]
    def getCloudFormation: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
    def getService: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ServiceHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("service", service)
    def getAccount: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.AccountHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("account", account)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.TagHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
  ) extends zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly {
    override val cloudFormation: Optional[
      List[zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFormation())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.CloudFormationHealth.wrap(item)
        }.toList
      )
    override val service
        : Optional[List[zio.aws.devopsguru.model.ServiceHealth.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.service())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.ServiceHealth.wrap(item)
          }.toList
        )
    override val account
        : Optional[List[zio.aws.devopsguru.model.AccountHealth.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.account())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.AccountHealth.wrap(item)
          }.toList
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val tags
        : Optional[List[zio.aws.devopsguru.model.TagHealth.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.TagHealth.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
  ): zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly =
    new Wrapper(impl)
}
