package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchMetricsDataSummary(
    timestampMetricValuePairList: Optional[
      Iterable[zio.aws.devopsguru.model.TimestampMetricValuePair]
    ] = Optional.Absent,
    statusCode: Optional[
      zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDataSummary = {
    import CloudWatchMetricsDataSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDataSummary
      .builder()
      .optionallyWith(
        timestampMetricValuePairList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timestampMetricValuePairList)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly =
    zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.wrap(buildAwsValue())
}
object CloudWatchMetricsDataSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDataSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudWatchMetricsDataSummary =
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary(
        timestampMetricValuePairList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusCode.map(value => value)
      )
    def timestampMetricValuePairList: Optional[
      List[zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly]
    ]
    def statusCode
        : Optional[zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode]
    def getTimestampMetricValuePairList: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "timestampMetricValuePairList",
      timestampMetricValuePairList
    )
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDataSummary
  ) extends zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly {
    override val timestampMetricValuePairList: Optional[
      List[zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timestampMetricValuePairList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.TimestampMetricValuePair.wrap(item)
        }.toList
      )
    override val statusCode
        : Optional[zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDataSummary
  ): zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly =
    new Wrapper(impl)
}
