package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  NumberOfLogLinesScanned,
  Timestamp,
  LogGroupName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AnomalousLogGroup(
    logGroupName: Optional[LogGroupName] = Optional.Absent,
    impactStartTime: Optional[Timestamp] = Optional.Absent,
    impactEndTime: Optional[Timestamp] = Optional.Absent,
    numberOfLogLinesScanned: Optional[NumberOfLogLinesScanned] =
      Optional.Absent,
    logAnomalyShowcases: Optional[
      Iterable[zio.aws.devopsguru.model.LogAnomalyShowcase]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup = {
    import AnomalousLogGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup
      .builder()
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .optionallyWith(
        impactStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.impactStartTime)
      .optionallyWith(
        impactEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.impactEndTime)
      .optionallyWith(
        numberOfLogLinesScanned.map(value =>
          NumberOfLogLinesScanned.unwrap(value): Integer
        )
      )(_.numberOfLogLinesScanned)
      .optionallyWith(
        logAnomalyShowcases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logAnomalyShowcases)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly =
    zio.aws.devopsguru.model.AnomalousLogGroup.wrap(buildAwsValue())
}
object AnomalousLogGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalousLogGroup =
      zio.aws.devopsguru.model.AnomalousLogGroup(
        logGroupName.map(value => value),
        impactStartTime.map(value => value),
        impactEndTime.map(value => value),
        numberOfLogLinesScanned.map(value => value),
        logAnomalyShowcases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def logGroupName: Optional[LogGroupName]
    def impactStartTime: Optional[Timestamp]
    def impactEndTime: Optional[Timestamp]
    def numberOfLogLinesScanned: Optional[NumberOfLogLinesScanned]
    def logAnomalyShowcases
        : Optional[List[zio.aws.devopsguru.model.LogAnomalyShowcase.ReadOnly]]
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getImpactStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("impactStartTime", impactStartTime)
    def getImpactEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("impactEndTime", impactEndTime)
    def getNumberOfLogLinesScanned
        : ZIO[Any, AwsError, NumberOfLogLinesScanned] = AwsError
      .unwrapOptionField("numberOfLogLinesScanned", numberOfLogLinesScanned)
    def getLogAnomalyShowcases: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.LogAnomalyShowcase.ReadOnly
    ]] = AwsError.unwrapOptionField("logAnomalyShowcases", logAnomalyShowcases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup
  ) extends zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly {
    override val logGroupName: Optional[LogGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => zio.aws.devopsguru.model.primitives.LogGroupName(value))
    override val impactStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.impactStartTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val impactEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.impactEndTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val numberOfLogLinesScanned: Optional[NumberOfLogLinesScanned] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfLogLinesScanned())
        .map(value =>
          zio.aws.devopsguru.model.primitives.NumberOfLogLinesScanned(value)
        )
    override val logAnomalyShowcases
        : Optional[List[zio.aws.devopsguru.model.LogAnomalyShowcase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logAnomalyShowcases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.LogAnomalyShowcase.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup
  ): zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly = new Wrapper(impl)
}
