package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  CloudWatchMetricsDimensionValue,
  CloudWatchMetricsDimensionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchMetricsDimension(
    name: Optional[CloudWatchMetricsDimensionName] = Optional.Absent,
    value: Optional[CloudWatchMetricsDimensionValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension = {
    import CloudWatchMetricsDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
      .builder()
      .optionallyWith(
        name.map(value =>
          CloudWatchMetricsDimensionName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        value.map(value =>
          CloudWatchMetricsDimensionValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly =
    zio.aws.devopsguru.model.CloudWatchMetricsDimension.wrap(buildAwsValue())
}
object CloudWatchMetricsDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudWatchMetricsDimension =
      zio.aws.devopsguru.model.CloudWatchMetricsDimension(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[CloudWatchMetricsDimensionName]
    def value: Optional[CloudWatchMetricsDimensionValue]
    def getName: ZIO[Any, AwsError, CloudWatchMetricsDimensionName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, CloudWatchMetricsDimensionValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
  ) extends zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly {
    override val name: Optional[CloudWatchMetricsDimensionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .CloudWatchMetricsDimensionName(value)
        )
    override val value: Optional[CloudWatchMetricsDimensionValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .CloudWatchMetricsDimensionValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
  ): zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly = new Wrapper(
    impl
  )
}
