package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMonitoredResourcesResponse(
    monitoredResourceIdentifiers: Iterable[
      zio.aws.devopsguru.model.MonitoredResourceIdentifier
    ],
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse = {
    import ListMonitoredResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse
      .builder()
      .monitoredResourceIdentifiers(monitoredResourceIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly =
    zio.aws.devopsguru.model.ListMonitoredResourcesResponse
      .wrap(buildAwsValue())
}
object ListMonitoredResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListMonitoredResourcesResponse =
      zio.aws.devopsguru.model.ListMonitoredResourcesResponse(
        monitoredResourceIdentifiers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def monitoredResourceIdentifiers
        : List[zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly]
    def nextToken: Optional[UuidNextToken]
    def getMonitoredResourceIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly
    ]] = ZIO.succeed(monitoredResourceIdentifiers)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse
  ) extends zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly {
    override val monitoredResourceIdentifiers
        : List[zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly] =
      impl
        .monitoredResourceIdentifiers()
        .asScala
        .map { item =>
          zio.aws.devopsguru.model.MonitoredResourceIdentifier.wrap(item)
        }
        .toList
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse
  ): zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
