package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  ResourceType,
  ResourceName,
  AnomalySource
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnomalySourceMetadata(
    source: Optional[AnomalySource] = Optional.Absent,
    sourceResourceName: Optional[ResourceName] = Optional.Absent,
    sourceResourceType: Optional[ResourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalySourceMetadata = {
    import AnomalySourceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalySourceMetadata
      .builder()
      .optionallyWith(
        source.map(value => AnomalySource.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        sourceResourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceResourceName)
      .optionallyWith(
        sourceResourceType.map(value =>
          ResourceType.unwrap(value): java.lang.String
        )
      )(_.sourceResourceType)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly =
    zio.aws.devopsguru.model.AnomalySourceMetadata.wrap(buildAwsValue())
}
object AnomalySourceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalySourceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalySourceMetadata =
      zio.aws.devopsguru.model.AnomalySourceMetadata(
        source.map(value => value),
        sourceResourceName.map(value => value),
        sourceResourceType.map(value => value)
      )
    def source: Optional[AnomalySource]
    def sourceResourceName: Optional[ResourceName]
    def sourceResourceType: Optional[ResourceType]
    def getSource: ZIO[Any, AwsError, AnomalySource] =
      AwsError.unwrapOptionField("source", source)
    def getSourceResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sourceResourceName", sourceResourceName)
    def getSourceResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("sourceResourceType", sourceResourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalySourceMetadata
  ) extends zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly {
    override val source: Optional[AnomalySource] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalySource(value))
    override val sourceResourceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceResourceName())
        .map(value => zio.aws.devopsguru.model.primitives.ResourceName(value))
    override val sourceResourceType: Optional[ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceResourceType())
        .map(value => zio.aws.devopsguru.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalySourceMetadata
  ): zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly = new Wrapper(impl)
}
