package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{TagValue, AppBoundaryKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateTagCollectionFilter(
    appBoundaryKey: AppBoundaryKey,
    tagValues: Iterable[TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFilter = {
    import UpdateTagCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFilter
      .builder()
      .appBoundaryKey(AppBoundaryKey.unwrap(appBoundaryKey): java.lang.String)
      .tagValues(tagValues.map { item =>
        TagValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.UpdateTagCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.UpdateTagCollectionFilter.wrap(buildAwsValue())
}
object UpdateTagCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateTagCollectionFilter =
      zio.aws.devopsguru.model
        .UpdateTagCollectionFilter(appBoundaryKey, tagValues)
    def appBoundaryKey: AppBoundaryKey
    def tagValues: List[TagValue]
    def getAppBoundaryKey: ZIO[Any, Nothing, AppBoundaryKey] =
      ZIO.succeed(appBoundaryKey)
    def getTagValues: ZIO[Any, Nothing, List[TagValue]] = ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFilter
  ) extends zio.aws.devopsguru.model.UpdateTagCollectionFilter.ReadOnly {
    override val appBoundaryKey: AppBoundaryKey =
      zio.aws.devopsguru.model.primitives.AppBoundaryKey(impl.appBoundaryKey())
    override val tagValues: List[TagValue] = impl
      .tagValues()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.primitives.TagValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFilter
  ): zio.aws.devopsguru.model.UpdateTagCollectionFilter.ReadOnly = new Wrapper(
    impl
  )
}
