package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{ResourceType, MonitoredResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonitoredResourceIdentifier(
    monitoredResourceName: Optional[MonitoredResourceName] = Optional.Absent,
    `type`: Optional[ResourceType] = Optional.Absent,
    resourcePermission: Optional[zio.aws.devopsguru.model.ResourcePermission] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier = {
    import MonitoredResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier
      .builder()
      .optionallyWith(
        monitoredResourceName.map(value =>
          MonitoredResourceName.unwrap(value): java.lang.String
        )
      )(_.monitoredResourceName)
      .optionallyWith(
        `type`.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(resourcePermission.map(value => value.unwrap))(
        _.resourcePermission
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly =
    zio.aws.devopsguru.model.MonitoredResourceIdentifier.wrap(buildAwsValue())
}
object MonitoredResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.MonitoredResourceIdentifier =
      zio.aws.devopsguru.model.MonitoredResourceIdentifier(
        monitoredResourceName.map(value => value),
        `type`.map(value => value),
        resourcePermission.map(value => value)
      )
    def monitoredResourceName: Optional[MonitoredResourceName]
    def `type`: Optional[ResourceType]
    def resourcePermission
        : Optional[zio.aws.devopsguru.model.ResourcePermission]
    def getMonitoredResourceName: ZIO[Any, AwsError, MonitoredResourceName] =
      AwsError.unwrapOptionField("monitoredResourceName", monitoredResourceName)
    def getType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getResourcePermission
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.ResourcePermission] =
      AwsError.unwrapOptionField("resourcePermission", resourcePermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier
  ) extends zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly {
    override val monitoredResourceName: Optional[MonitoredResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoredResourceName())
        .map(value =>
          zio.aws.devopsguru.model.primitives.MonitoredResourceName(value)
        )
    override val `type`: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.devopsguru.model.primitives.ResourceType(value))
    override val resourcePermission
        : Optional[zio.aws.devopsguru.model.ResourcePermission] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePermission())
        .map(value => zio.aws.devopsguru.model.ResourcePermission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier
  ): zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly =
    new Wrapper(impl)
}
