package zio.aws.devopsguru
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsMetricDimension,
  PerformanceInsightsMetricFilterValue,
  StackName,
  TagValue,
  PerformanceInsightsMetricFilterKey,
  ResourceArn,
  OrganizationalUnitId,
  AwsAccountId
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.devopsguru.model.primitives.RecommendationRelatedEventResourceName.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AnomalyDescription extends Subtype[String]
    type AnomalyDescription =
      zio.aws.devopsguru.model.primitives.AnomalyDescription.Type
    object AnomalyId extends Subtype[String]
    type AnomalyId = zio.aws.devopsguru.model.primitives.AnomalyId.Type
    object AnomalyLimit extends Subtype[Double]
    type AnomalyLimit = zio.aws.devopsguru.model.primitives.AnomalyLimit.Type
    object AnomalyName extends Subtype[String]
    type AnomalyName = zio.aws.devopsguru.model.primitives.AnomalyName.Type
    object AnomalySource extends Subtype[String]
    type AnomalySource = zio.aws.devopsguru.model.primitives.AnomalySource.Type
    object AppBoundaryKey extends Subtype[String]
    type AppBoundaryKey =
      zio.aws.devopsguru.model.primitives.AppBoundaryKey.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId = zio.aws.devopsguru.model.primitives.AwsAccountId.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.devopsguru.model.primitives.ClientToken.Type
    object CloudWatchMetricsDimensionName extends Subtype[String]
    type CloudWatchMetricsDimensionName =
      zio.aws.devopsguru.model.primitives.CloudWatchMetricsDimensionName.Type
    object CloudWatchMetricsDimensionValue extends Subtype[String]
    type CloudWatchMetricsDimensionValue =
      zio.aws.devopsguru.model.primitives.CloudWatchMetricsDimensionValue.Type
    object CloudWatchMetricsMetricName extends Subtype[String]
    type CloudWatchMetricsMetricName =
      zio.aws.devopsguru.model.primitives.CloudWatchMetricsMetricName.Type
    object CloudWatchMetricsNamespace extends Subtype[String]
    type CloudWatchMetricsNamespace =
      zio.aws.devopsguru.model.primitives.CloudWatchMetricsNamespace.Type
    object CloudWatchMetricsPeriod extends Subtype[Int]
    type CloudWatchMetricsPeriod =
      zio.aws.devopsguru.model.primitives.CloudWatchMetricsPeriod.Type
    object CloudWatchMetricsUnit extends Subtype[String]
    type CloudWatchMetricsUnit =
      zio.aws.devopsguru.model.primitives.CloudWatchMetricsUnit.Type
    object Cost extends Subtype[Double]
    type Cost = zio.aws.devopsguru.model.primitives.Cost.Type
    object CostEstimationServiceResourceCount extends Subtype[Int]
    type CostEstimationServiceResourceCount =
      zio.aws.devopsguru.model.primitives.CostEstimationServiceResourceCount.Type
    object EventId extends Subtype[String]
    type EventId = zio.aws.devopsguru.model.primitives.EventId.Type
    object EventName extends Subtype[String]
    type EventName = zio.aws.devopsguru.model.primitives.EventName.Type
    object EventResourceArn extends Subtype[String]
    type EventResourceArn =
      zio.aws.devopsguru.model.primitives.EventResourceArn.Type
    object EventResourceName extends Subtype[String]
    type EventResourceName =
      zio.aws.devopsguru.model.primitives.EventResourceName.Type
    object EventResourceType extends Subtype[String]
    type EventResourceType =
      zio.aws.devopsguru.model.primitives.EventResourceType.Type
    object EventSource extends Subtype[String]
    type EventSource = zio.aws.devopsguru.model.primitives.EventSource.Type
    object Explanation extends Subtype[String]
    type Explanation = zio.aws.devopsguru.model.primitives.Explanation.Type
    object InsightDescription extends Subtype[String]
    type InsightDescription =
      zio.aws.devopsguru.model.primitives.InsightDescription.Type
    object InsightId extends Subtype[String]
    type InsightId = zio.aws.devopsguru.model.primitives.InsightId.Type
    object InsightName extends Subtype[String]
    type InsightName = zio.aws.devopsguru.model.primitives.InsightName.Type
    object ListAnomaliesForInsightMaxResults extends Subtype[Int]
    type ListAnomaliesForInsightMaxResults =
      zio.aws.devopsguru.model.primitives.ListAnomaliesForInsightMaxResults.Type
    object ListAnomalousLogGroupsMaxResults extends Subtype[Int]
    type ListAnomalousLogGroupsMaxResults =
      zio.aws.devopsguru.model.primitives.ListAnomalousLogGroupsMaxResults.Type
    object ListEventsMaxResults extends Subtype[Int]
    type ListEventsMaxResults =
      zio.aws.devopsguru.model.primitives.ListEventsMaxResults.Type
    object ListInsightsMaxResults extends Subtype[Int]
    type ListInsightsMaxResults =
      zio.aws.devopsguru.model.primitives.ListInsightsMaxResults.Type
    object ListMonitoredResourcesMaxResults extends Subtype[Int]
    type ListMonitoredResourcesMaxResults =
      zio.aws.devopsguru.model.primitives.ListMonitoredResourcesMaxResults.Type
    object LogAnomalyToken extends Subtype[String]
    type LogAnomalyToken =
      zio.aws.devopsguru.model.primitives.LogAnomalyToken.Type
    object LogEventId extends Subtype[String]
    type LogEventId = zio.aws.devopsguru.model.primitives.LogEventId.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName = zio.aws.devopsguru.model.primitives.LogGroupName.Type
    object LogStreamName extends Subtype[String]
    type LogStreamName = zio.aws.devopsguru.model.primitives.LogStreamName.Type
    object MeanTimeToRecoverInMilliseconds extends Subtype[Long]
    type MeanTimeToRecoverInMilliseconds =
      zio.aws.devopsguru.model.primitives.MeanTimeToRecoverInMilliseconds.Type
    object MetricValue extends Subtype[Double]
    type MetricValue = zio.aws.devopsguru.model.primitives.MetricValue.Type
    object MonitoredResourceName extends Subtype[String]
    type MonitoredResourceName =
      zio.aws.devopsguru.model.primitives.MonitoredResourceName.Type
    object NotificationChannelId extends Subtype[String]
    type NotificationChannelId =
      zio.aws.devopsguru.model.primitives.NotificationChannelId.Type
    object NumMetricsAnalyzed extends Subtype[Int]
    type NumMetricsAnalyzed =
      zio.aws.devopsguru.model.primitives.NumMetricsAnalyzed.Type
    object NumOpenProactiveInsights extends Subtype[Int]
    type NumOpenProactiveInsights =
      zio.aws.devopsguru.model.primitives.NumOpenProactiveInsights.Type
    object NumOpenReactiveInsights extends Subtype[Int]
    type NumOpenReactiveInsights =
      zio.aws.devopsguru.model.primitives.NumOpenReactiveInsights.Type
    object NumProactiveInsights extends Subtype[Int]
    type NumProactiveInsights =
      zio.aws.devopsguru.model.primitives.NumProactiveInsights.Type
    object NumReactiveInsights extends Subtype[Int]
    type NumReactiveInsights =
      zio.aws.devopsguru.model.primitives.NumReactiveInsights.Type
    object NumberOfLogLinesOccurrences extends Subtype[Int]
    type NumberOfLogLinesOccurrences =
      zio.aws.devopsguru.model.primitives.NumberOfLogLinesOccurrences.Type
    object NumberOfLogLinesScanned extends Subtype[Int]
    type NumberOfLogLinesScanned =
      zio.aws.devopsguru.model.primitives.NumberOfLogLinesScanned.Type
    object OrganizationResourceCollectionMaxResults extends Subtype[Int]
    type OrganizationResourceCollectionMaxResults =
      zio.aws.devopsguru.model.primitives.OrganizationResourceCollectionMaxResults.Type
    object OrganizationalUnitId extends Subtype[String]
    type OrganizationalUnitId =
      zio.aws.devopsguru.model.primitives.OrganizationalUnitId.Type
    object PerformanceInsightsMetricDimension extends Subtype[String]
    type PerformanceInsightsMetricDimension =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricDimension.Type
    object PerformanceInsightsMetricDisplayName extends Subtype[String]
    type PerformanceInsightsMetricDisplayName =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricDisplayName.Type
    object PerformanceInsightsMetricFilterKey extends Subtype[String]
    type PerformanceInsightsMetricFilterKey =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricFilterKey.Type
    object PerformanceInsightsMetricFilterValue extends Subtype[String]
    type PerformanceInsightsMetricFilterValue =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricFilterValue.Type
    object PerformanceInsightsMetricGroup extends Subtype[String]
    type PerformanceInsightsMetricGroup =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricGroup.Type
    object PerformanceInsightsMetricLimitInteger extends Subtype[Int]
    type PerformanceInsightsMetricLimitInteger =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricLimitInteger.Type
    object PerformanceInsightsMetricName extends Subtype[String]
    type PerformanceInsightsMetricName =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricName.Type
    object PerformanceInsightsMetricUnit extends Subtype[String]
    type PerformanceInsightsMetricUnit =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricUnit.Type
    object PerformanceInsightsReferenceName extends Subtype[String]
    type PerformanceInsightsReferenceName =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsReferenceName.Type
    object PerformanceInsightsStatType extends Subtype[String]
    type PerformanceInsightsStatType =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsStatType.Type
    object PerformanceInsightsValueDouble extends Subtype[Double]
    type PerformanceInsightsValueDouble =
      zio.aws.devopsguru.model.primitives.PerformanceInsightsValueDouble.Type
    object RecommendationCategory extends Subtype[String]
    type RecommendationCategory =
      zio.aws.devopsguru.model.primitives.RecommendationCategory.Type
    object RecommendationDescription extends Subtype[String]
    type RecommendationDescription =
      zio.aws.devopsguru.model.primitives.RecommendationDescription.Type
    object RecommendationLink extends Subtype[String]
    type RecommendationLink =
      zio.aws.devopsguru.model.primitives.RecommendationLink.Type
    object RecommendationName extends Subtype[String]
    type RecommendationName =
      zio.aws.devopsguru.model.primitives.RecommendationName.Type
    object RecommendationReason extends Subtype[String]
    type RecommendationReason =
      zio.aws.devopsguru.model.primitives.RecommendationReason.Type
    object RecommendationRelatedAnomalyResourceName extends Subtype[String]
    type RecommendationRelatedAnomalyResourceName =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedAnomalyResourceName.Type
    object RecommendationRelatedAnomalyResourceType extends Subtype[String]
    type RecommendationRelatedAnomalyResourceType =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedAnomalyResourceType.Type
    object RecommendationRelatedCloudWatchMetricsSourceMetricName
        extends Subtype[String]
    type RecommendationRelatedCloudWatchMetricsSourceMetricName =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedCloudWatchMetricsSourceMetricName.Type
    object RecommendationRelatedCloudWatchMetricsSourceNamespace
        extends Subtype[String]
    type RecommendationRelatedCloudWatchMetricsSourceNamespace =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedCloudWatchMetricsSourceNamespace.Type
    object RecommendationRelatedEventName extends Subtype[String]
    type RecommendationRelatedEventName =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedEventName.Type
    object RecommendationRelatedEventResourceName extends Subtype[String]
    type RecommendationRelatedEventResourceName =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedEventResourceName.Type
    object RecommendationRelatedEventResourceType extends Subtype[String]
    type RecommendationRelatedEventResourceType =
      zio.aws.devopsguru.model.primitives.RecommendationRelatedEventResourceType.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.devopsguru.model.primitives.ResourceArn.Type
    object ResourceHours extends Subtype[Long]
    type ResourceHours = zio.aws.devopsguru.model.primitives.ResourceHours.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.devopsguru.model.primitives.ResourceName.Type
    object ResourceType extends Subtype[String]
    type ResourceType = zio.aws.devopsguru.model.primitives.ResourceType.Type
    object SearchInsightsMaxResults extends Subtype[Int]
    type SearchInsightsMaxResults =
      zio.aws.devopsguru.model.primitives.SearchInsightsMaxResults.Type
    object SearchOrganizationInsightsMaxResults extends Subtype[Int]
    type SearchOrganizationInsightsMaxResults =
      zio.aws.devopsguru.model.primitives.SearchOrganizationInsightsMaxResults.Type
    object SsmOpsItemId extends Subtype[String]
    type SsmOpsItemId = zio.aws.devopsguru.model.primitives.SsmOpsItemId.Type
    object StackName extends Subtype[String]
    type StackName = zio.aws.devopsguru.model.primitives.StackName.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.devopsguru.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.devopsguru.model.primitives.Timestamp.Type
    object TopicArn extends Subtype[String]
    type TopicArn = zio.aws.devopsguru.model.primitives.TopicArn.Type
    object UuidNextToken extends Subtype[String]
    type UuidNextToken = zio.aws.devopsguru.model.primitives.UuidNextToken.Type
  }
  type AccountHealths = List[zio.aws.devopsguru.model.AccountHealth]
  type AccountIdList = List[AwsAccountId]
  type AnomalousLogGroups = List[zio.aws.devopsguru.model.AnomalousLogGroup]
  type AnomalyResources = List[zio.aws.devopsguru.model.AnomalyResource]
  type AssociatedResourceArns = List[ResourceArn]
  type Channels = List[zio.aws.devopsguru.model.NotificationChannel]
  type CloudFormationHealths =
    List[zio.aws.devopsguru.model.CloudFormationHealth]
  type CloudWatchMetricsDetails =
    List[zio.aws.devopsguru.model.CloudWatchMetricsDetail]
  type CloudWatchMetricsDimensions =
    List[zio.aws.devopsguru.model.CloudWatchMetricsDimension]
  type CostEstimationStackNames = List[StackName]
  type CostEstimationTagValues = List[TagValue]
  type EventResources = List[zio.aws.devopsguru.model.EventResource]
  type Events = List[zio.aws.devopsguru.model.Event]
  type InsightSeverities = List[zio.aws.devopsguru.model.InsightSeverity]
  type InsightStatuses = List[zio.aws.devopsguru.model.InsightStatus]
  type ListInsightsAccountIdList = List[AwsAccountId]
  type ListInsightsOrganizationalUnitIdList = List[OrganizationalUnitId]
  type LogAnomalyClasses = List[zio.aws.devopsguru.model.LogAnomalyClass]
  type LogAnomalyShowcases = List[zio.aws.devopsguru.model.LogAnomalyShowcase]
  type MonitoredResourceIdentifiers =
    List[zio.aws.devopsguru.model.MonitoredResourceIdentifier]
  type NotificationMessageTypes =
    List[zio.aws.devopsguru.model.NotificationMessageType]
  type OrganizationalUnitIdList = List[OrganizationalUnitId]
  type PerformanceInsightsMetricDimensions =
    List[PerformanceInsightsMetricDimension]
  type PerformanceInsightsMetricFilterMap = Map[
    PerformanceInsightsMetricFilterKey,
    PerformanceInsightsMetricFilterValue
  ]
  type PerformanceInsightsMetricsDetails =
    List[zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail]
  type PerformanceInsightsReferenceDataList =
    List[zio.aws.devopsguru.model.PerformanceInsightsReferenceData]
  type PerformanceInsightsStats =
    List[zio.aws.devopsguru.model.PerformanceInsightsStat]
  type ProactiveAnomalies =
    List[zio.aws.devopsguru.model.ProactiveAnomalySummary]
  type ProactiveInsights =
    List[zio.aws.devopsguru.model.ProactiveInsightSummary]
  type ProactiveOrganizationInsights =
    List[zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary]
  type ReactiveAnomalies = List[zio.aws.devopsguru.model.ReactiveAnomalySummary]
  type ReactiveInsights = List[zio.aws.devopsguru.model.ReactiveInsightSummary]
  type ReactiveOrganizationInsights =
    List[zio.aws.devopsguru.model.ReactiveOrganizationInsightSummary]
  type RecommendationRelatedAnomalies =
    List[zio.aws.devopsguru.model.RecommendationRelatedAnomaly]
  type RecommendationRelatedAnomalyResources =
    List[zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource]
  type RecommendationRelatedCloudWatchMetricsSourceDetails = List[
    zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ]
  type RecommendationRelatedEventResources =
    List[zio.aws.devopsguru.model.RecommendationRelatedEventResource]
  type RecommendationRelatedEvents =
    List[zio.aws.devopsguru.model.RecommendationRelatedEvent]
  type Recommendations = List[zio.aws.devopsguru.model.Recommendation]
  type RelatedAnomalySourceDetails =
    List[zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail]
  type ResourceTypeFilters = List[zio.aws.devopsguru.model.ResourceTypeFilter]
  type SearchInsightsAccountIdList = List[AwsAccountId]
  type ServiceHealths = List[zio.aws.devopsguru.model.ServiceHealth]
  type ServiceNames = List[zio.aws.devopsguru.model.ServiceName]
  type ServiceResourceCosts = List[zio.aws.devopsguru.model.ServiceResourceCost]
  type StackNames = List[StackName]
  type TagCollectionFilters = List[zio.aws.devopsguru.model.TagCollectionFilter]
  type TagCollections = List[zio.aws.devopsguru.model.TagCollection]
  type TagCostEstimationResourceCollectionFilters =
    List[zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter]
  type TagHealths = List[zio.aws.devopsguru.model.TagHealth]
  type TagValues = List[TagValue]
  type TimestampMetricValuePairList =
    List[zio.aws.devopsguru.model.TimestampMetricValuePair]
  type UpdateStackNames = List[StackName]
  type UpdateTagCollectionFilters =
    List[zio.aws.devopsguru.model.UpdateTagCollectionFilter]
  type UpdateTagValues = List[TagValue]
}
