package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait EventSourceOptInStatus {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus
}
object EventSourceOptInStatus {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus
  ): zio.aws.devopsguru.model.EventSourceOptInStatus = value match {
    case software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.EventSourceOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus =
      software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.devopsguru.model.EventSourceOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus =
      software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus.ENABLED
  }
  case object DISABLED extends zio.aws.devopsguru.model.EventSourceOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus =
      software.amazon.awssdk.services.devopsguru.model.EventSourceOptInStatus.DISABLED
  }
}
