package zio.aws.devopsguru
import zio.aws.devopsguru.model.{
  GetCostEstimationRequest,
  UpdateEventSourcesConfigRequest,
  ListNotificationChannelsRequest,
  DescribeInsightRequest,
  ListRecommendationsRequest,
  SearchInsightsRequest,
  UpdateResourceCollectionRequest,
  DescribeOrganizationResourceCollectionHealthRequest,
  ListAnomalousLogGroupsRequest,
  DeleteInsightRequest,
  DescribeAccountHealthRequest,
  DescribeAnomalyRequest,
  ListEventsRequest,
  SearchOrganizationInsightsRequest,
  ListOrganizationInsightsRequest,
  UpdateServiceIntegrationRequest,
  DescribeFeedbackRequest,
  DescribeAccountOverviewRequest,
  DescribeOrganizationOverviewRequest,
  GetResourceCollectionRequest,
  DescribeEventSourcesConfigRequest,
  ListMonitoredResourcesRequest,
  ListAnomaliesForInsightRequest,
  ListInsightsRequest,
  DescribeServiceIntegrationRequest,
  StartCostEstimationRequest,
  PutFeedbackRequest,
  RemoveNotificationChannelRequest,
  DescribeOrganizationHealthRequest,
  DescribeResourceCollectionHealthRequest,
  AddNotificationChannelRequest
}
import zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object DevOpsGuruMock extends Mock[DevOpsGuru] {
  object DescribeServiceIntegration
      extends Effect[
        DescribeServiceIntegrationRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly
      ]
  object DescribeEventSourcesConfig
      extends Effect[
        DescribeEventSourcesConfigRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly
      ]
  object StartCostEstimation
      extends Effect[
        StartCostEstimationRequest,
        AwsError,
        zio.aws.devopsguru.model.StartCostEstimationResponse.ReadOnly
      ]
  object GetCostEstimation
      extends Effect[GetCostEstimationRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly,
        zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly
      ]]
  object GetCostEstimationPaginated
      extends Effect[
        GetCostEstimationRequest,
        AwsError,
        zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly
      ]
  object SearchInsights
      extends Stream[
        SearchInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
      ]
  object SearchInsightsPaginated
      extends Effect[
        SearchInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly
      ]
  object DescribeInsight
      extends Effect[
        DescribeInsightRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly
      ]
  object DescribeAccountOverview
      extends Effect[
        DescribeAccountOverviewRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly
      ]
  object DescribeResourceCollectionHealth
      extends Stream[
        DescribeResourceCollectionHealthRequest,
        AwsError,
        zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
      ]
  object DescribeResourceCollectionHealthPaginated
      extends Effect[
        DescribeResourceCollectionHealthRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly
      ]
  object GetResourceCollection
      extends Effect[
        GetResourceCollectionRequest,
        AwsError,
        zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly
      ]
  object DeleteInsight
      extends Effect[
        DeleteInsightRequest,
        AwsError,
        zio.aws.devopsguru.model.DeleteInsightResponse.ReadOnly
      ]
  object ListAnomalousLogGroups
      extends Effect[
        ListAnomalousLogGroupsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly,
          zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly
        ]
      ]
  object ListAnomalousLogGroupsPaginated
      extends Effect[
        ListAnomalousLogGroupsRequest,
        AwsError,
        zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly
      ]
  object ListRecommendations
      extends Stream[
        ListRecommendationsRequest,
        AwsError,
        zio.aws.devopsguru.model.Recommendation.ReadOnly
      ]
  object ListRecommendationsPaginated
      extends Effect[
        ListRecommendationsRequest,
        AwsError,
        zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly
      ]
  object ListMonitoredResources
      extends Stream[
        ListMonitoredResourcesRequest,
        AwsError,
        zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly
      ]
  object ListMonitoredResourcesPaginated
      extends Effect[
        ListMonitoredResourcesRequest,
        AwsError,
        zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly
      ]
  object SearchOrganizationInsights
      extends Stream[
        SearchOrganizationInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
      ]
  object SearchOrganizationInsightsPaginated
      extends Effect[
        SearchOrganizationInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.SearchOrganizationInsightsResponse.ReadOnly
      ]
  object ListEvents
      extends Stream[
        ListEventsRequest,
        AwsError,
        zio.aws.devopsguru.model.Event.ReadOnly
      ]
  object ListEventsPaginated
      extends Effect[
        ListEventsRequest,
        AwsError,
        zio.aws.devopsguru.model.ListEventsResponse.ReadOnly
      ]
  object DescribeAccountHealth
      extends Effect[DescribeAccountHealthRequest, AwsError, ReadOnly]
  object ListOrganizationInsights
      extends Stream[
        ListOrganizationInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
      ]
  object ListOrganizationInsightsPaginated
      extends Effect[
        ListOrganizationInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly
      ]
  object RemoveNotificationChannel
      extends Effect[
        RemoveNotificationChannelRequest,
        AwsError,
        zio.aws.devopsguru.model.RemoveNotificationChannelResponse.ReadOnly
      ]
  object DescribeFeedback
      extends Effect[
        DescribeFeedbackRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly
      ]
  object DescribeOrganizationOverview
      extends Effect[
        DescribeOrganizationOverviewRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly
      ]
  object UpdateServiceIntegration
      extends Effect[
        UpdateServiceIntegrationRequest,
        AwsError,
        zio.aws.devopsguru.model.UpdateServiceIntegrationResponse.ReadOnly
      ]
  object UpdateResourceCollection
      extends Effect[
        UpdateResourceCollectionRequest,
        AwsError,
        zio.aws.devopsguru.model.UpdateResourceCollectionResponse.ReadOnly
      ]
  object PutFeedback
      extends Effect[
        PutFeedbackRequest,
        AwsError,
        zio.aws.devopsguru.model.PutFeedbackResponse.ReadOnly
      ]
  object DescribeOrganizationHealth
      extends Effect[
        DescribeOrganizationHealthRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeOrganizationHealthResponse.ReadOnly
      ]
  object DescribeAnomaly
      extends Effect[
        DescribeAnomalyRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly
      ]
  object AddNotificationChannel
      extends Effect[
        AddNotificationChannelRequest,
        AwsError,
        zio.aws.devopsguru.model.AddNotificationChannelResponse.ReadOnly
      ]
  object UpdateEventSourcesConfig
      extends Effect[
        UpdateEventSourcesConfigRequest,
        AwsError,
        zio.aws.devopsguru.model.UpdateEventSourcesConfigResponse.ReadOnly
      ]
  object ListInsights
      extends Stream[
        ListInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
      ]
  object ListInsightsPaginated
      extends Effect[
        ListInsightsRequest,
        AwsError,
        zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly
      ]
  object DescribeOrganizationResourceCollectionHealth
      extends Stream[
        DescribeOrganizationResourceCollectionHealthRequest,
        AwsError,
        zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
      ]
  object DescribeOrganizationResourceCollectionHealthPaginated
      extends Effect[
        DescribeOrganizationResourceCollectionHealthRequest,
        AwsError,
        zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly
      ]
  object ListNotificationChannels
      extends Stream[
        ListNotificationChannelsRequest,
        AwsError,
        zio.aws.devopsguru.model.NotificationChannel.ReadOnly
      ]
  object ListNotificationChannelsPaginated
      extends Effect[
        ListNotificationChannelsRequest,
        AwsError,
        zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly
      ]
  object ListAnomaliesForInsight
      extends Stream[
        ListAnomaliesForInsightRequest,
        AwsError,
        zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly
      ]
  object ListAnomaliesForInsightPaginated
      extends Effect[
        ListAnomaliesForInsightRequest,
        AwsError,
        zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DevOpsGuru] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, DevOpsGuru] { rts =>
        ZIO.succeed {
          new DevOpsGuru {
            val api: DevOpsGuruAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): DevOpsGuru = this
            def describeServiceIntegration(
                request: DescribeServiceIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly
            ] = proxy(DescribeServiceIntegration, request)
            def describeEventSourcesConfig(
                request: DescribeEventSourcesConfigRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly
            ] = proxy(DescribeEventSourcesConfig, request)
            def startCostEstimation(request: StartCostEstimationRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.StartCostEstimationResponse.ReadOnly
            ] = proxy(StartCostEstimation, request)
            def getCostEstimation(
                request: GetCostEstimationRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly,
              zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly
            ]] = proxy(GetCostEstimation, request)
            def getCostEstimationPaginated(
                request: GetCostEstimationRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly
            ] = proxy(GetCostEstimationPaginated, request)
            def searchInsights(request: SearchInsightsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchInsights, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchInsightsPaginated(request: SearchInsightsRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly
            ] = proxy(SearchInsightsPaginated, request)
            def describeInsight(request: DescribeInsightRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly
            ] = proxy(DescribeInsight, request)
            def describeAccountOverview(
                request: DescribeAccountOverviewRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly
            ] = proxy(DescribeAccountOverview, request)
            def describeResourceCollectionHealth(
                request: DescribeResourceCollectionHealthRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeResourceCollectionHealth, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeResourceCollectionHealthPaginated(
                request: DescribeResourceCollectionHealthRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly
            ] = proxy(DescribeResourceCollectionHealthPaginated, request)
            def getResourceCollection(
                request: GetResourceCollectionRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly
            ] = proxy(GetResourceCollection, request)
            def deleteInsight(request: DeleteInsightRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.DeleteInsightResponse.ReadOnly
            ] = proxy(DeleteInsight, request)
            def listAnomalousLogGroups(
                request: ListAnomalousLogGroupsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly,
              zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly
            ]] = proxy(ListAnomalousLogGroups, request)
            def listAnomalousLogGroupsPaginated(
                request: ListAnomalousLogGroupsRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly
            ] = proxy(ListAnomalousLogGroupsPaginated, request)
            def listRecommendations(
                request: ListRecommendationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.Recommendation.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecommendations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecommendationsPaginated(
                request: ListRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly
            ] = proxy(ListRecommendationsPaginated, request)
            def listMonitoredResources(
                request: ListMonitoredResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMonitoredResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMonitoredResourcesPaginated(
                request: ListMonitoredResourcesRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly
            ] = proxy(ListMonitoredResourcesPaginated, request)
            def searchOrganizationInsights(
                request: SearchOrganizationInsightsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchOrganizationInsights, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchOrganizationInsightsPaginated(
                request: SearchOrganizationInsightsRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.SearchOrganizationInsightsResponse.ReadOnly
            ] = proxy(SearchOrganizationInsightsPaginated, request)
            def listEvents(
                request: ListEventsRequest
            ): ZStream[Any, AwsError, zio.aws.devopsguru.model.Event.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListEvents, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listEventsPaginated(request: ListEventsRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.ListEventsResponse.ReadOnly
            ] = proxy(ListEventsPaginated, request)
            def describeAccountHealth(
                request: DescribeAccountHealthRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribeAccountHealth, request)
            def listOrganizationInsights(
                request: ListOrganizationInsightsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOrganizationInsights, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOrganizationInsightsPaginated(
                request: ListOrganizationInsightsRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly
            ] = proxy(ListOrganizationInsightsPaginated, request)
            def removeNotificationChannel(
                request: RemoveNotificationChannelRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.RemoveNotificationChannelResponse.ReadOnly
            ] = proxy(RemoveNotificationChannel, request)
            def describeFeedback(request: DescribeFeedbackRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly
            ] = proxy(DescribeFeedback, request)
            def describeOrganizationOverview(
                request: DescribeOrganizationOverviewRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly
            ] = proxy(DescribeOrganizationOverview, request)
            def updateServiceIntegration(
                request: UpdateServiceIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.UpdateServiceIntegrationResponse.ReadOnly
            ] = proxy(UpdateServiceIntegration, request)
            def updateResourceCollection(
                request: UpdateResourceCollectionRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.UpdateResourceCollectionResponse.ReadOnly
            ] = proxy(UpdateResourceCollection, request)
            def putFeedback(request: PutFeedbackRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.PutFeedbackResponse.ReadOnly
            ] = proxy(PutFeedback, request)
            def describeOrganizationHealth(
                request: DescribeOrganizationHealthRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeOrganizationHealthResponse.ReadOnly
            ] = proxy(DescribeOrganizationHealth, request)
            def describeAnomaly(request: DescribeAnomalyRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly
            ] = proxy(DescribeAnomaly, request)
            def addNotificationChannel(
                request: AddNotificationChannelRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.AddNotificationChannelResponse.ReadOnly
            ] = proxy(AddNotificationChannel, request)
            def updateEventSourcesConfig(
                request: UpdateEventSourcesConfigRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.UpdateEventSourcesConfigResponse.ReadOnly
            ] = proxy(UpdateEventSourcesConfig, request)
            def listInsights(request: ListInsightsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInsights, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInsightsPaginated(request: ListInsightsRequest): IO[
              AwsError,
              zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly
            ] = proxy(ListInsightsPaginated, request)
            def describeOrganizationResourceCollectionHealth(
                request: DescribeOrganizationResourceCollectionHealthRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrganizationResourceCollectionHealth, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrganizationResourceCollectionHealthPaginated(
                request: DescribeOrganizationResourceCollectionHealthRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly
            ] = proxy(
              DescribeOrganizationResourceCollectionHealthPaginated,
              request
            )
            def listNotificationChannels(
                request: ListNotificationChannelsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.NotificationChannel.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotificationChannels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotificationChannelsPaginated(
                request: ListNotificationChannelsRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly
            ] = proxy(ListNotificationChannelsPaginated, request)
            def listAnomaliesForInsight(
                request: ListAnomaliesForInsightRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAnomaliesForInsight, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAnomaliesForInsightPaginated(
                request: ListAnomaliesForInsightRequest
            ): IO[
              AwsError,
              zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly
            ] = proxy(ListAnomaliesForInsightPaginated, request)
          }
        }
      }
    }
  }
}
