package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  MeanTimeToRecoverInMilliseconds,
  NumOpenReactiveInsights,
  NumOpenProactiveInsights
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InsightHealth(
    openProactiveInsights: Optional[NumOpenProactiveInsights] = Optional.Absent,
    openReactiveInsights: Optional[NumOpenReactiveInsights] = Optional.Absent,
    meanTimeToRecoverInMilliseconds: Optional[MeanTimeToRecoverInMilliseconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.InsightHealth = {
    import InsightHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.InsightHealth
      .builder()
      .optionallyWith(
        openProactiveInsights.map(value =>
          NumOpenProactiveInsights.unwrap(value): Integer
        )
      )(_.openProactiveInsights)
      .optionallyWith(
        openReactiveInsights.map(value =>
          NumOpenReactiveInsights.unwrap(value): Integer
        )
      )(_.openReactiveInsights)
      .optionallyWith(
        meanTimeToRecoverInMilliseconds.map(value =>
          MeanTimeToRecoverInMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.meanTimeToRecoverInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.InsightHealth.ReadOnly =
    zio.aws.devopsguru.model.InsightHealth.wrap(buildAwsValue())
}
object InsightHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.InsightHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.InsightHealth =
      zio.aws.devopsguru.model.InsightHealth(
        openProactiveInsights.map(value => value),
        openReactiveInsights.map(value => value),
        meanTimeToRecoverInMilliseconds.map(value => value)
      )
    def openProactiveInsights: Optional[NumOpenProactiveInsights]
    def openReactiveInsights: Optional[NumOpenReactiveInsights]
    def meanTimeToRecoverInMilliseconds
        : Optional[MeanTimeToRecoverInMilliseconds]
    def getOpenProactiveInsights: ZIO[Any, AwsError, NumOpenProactiveInsights] =
      AwsError.unwrapOptionField("openProactiveInsights", openProactiveInsights)
    def getOpenReactiveInsights: ZIO[Any, AwsError, NumOpenReactiveInsights] =
      AwsError.unwrapOptionField("openReactiveInsights", openReactiveInsights)
    def getMeanTimeToRecoverInMilliseconds
        : ZIO[Any, AwsError, MeanTimeToRecoverInMilliseconds] =
      AwsError.unwrapOptionField(
        "meanTimeToRecoverInMilliseconds",
        meanTimeToRecoverInMilliseconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.InsightHealth
  ) extends zio.aws.devopsguru.model.InsightHealth.ReadOnly {
    override val openProactiveInsights: Optional[NumOpenProactiveInsights] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openProactiveInsights())
        .map(value =>
          zio.aws.devopsguru.model.primitives.NumOpenProactiveInsights(value)
        )
    override val openReactiveInsights: Optional[NumOpenReactiveInsights] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openReactiveInsights())
        .map(value =>
          zio.aws.devopsguru.model.primitives.NumOpenReactiveInsights(value)
        )
    override val meanTimeToRecoverInMilliseconds
        : Optional[MeanTimeToRecoverInMilliseconds] = zio.aws.core.internal
      .optionalFromNullable(impl.meanTimeToRecoverInMilliseconds())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .MeanTimeToRecoverInMilliseconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.InsightHealth
  ): zio.aws.devopsguru.model.InsightHealth.ReadOnly = new Wrapper(impl)
}
