package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.InsightId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFeedbackRequest(
    insightId: Optional[InsightId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest = {
    import DescribeFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest
      .builder()
      .optionallyWith(
        insightId.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.insightId)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DescribeFeedbackRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeFeedbackRequest.wrap(buildAwsValue())
}
object DescribeFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeFeedbackRequest =
      zio.aws.devopsguru.model
        .DescribeFeedbackRequest(insightId.map(value => value))
    def insightId: Optional[InsightId]
    def getInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("insightId", insightId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest
  ) extends zio.aws.devopsguru.model.DescribeFeedbackRequest.ReadOnly {
    override val insightId: Optional[InsightId] = zio.aws.core.internal
      .optionalFromNullable(impl.insightId())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest
  ): zio.aws.devopsguru.model.DescribeFeedbackRequest.ReadOnly = new Wrapper(
    impl
  )
}
