package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.AnomalyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecommendationRelatedAnomaly(
    resources: Optional[
      Iterable[zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource]
    ] = Optional.Absent,
    sourceDetails: Optional[Iterable[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail
    ]] = Optional.Absent,
    anomalyId: Optional[AnomalyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly = {
    import RecommendationRelatedAnomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        sourceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDetails)
      .optionallyWith(
        anomalyId.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.anomalyId)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedAnomaly.wrap(buildAwsValue())
}
object RecommendationRelatedAnomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.RecommendationRelatedAnomaly =
      zio.aws.devopsguru.model.RecommendationRelatedAnomaly(
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        anomalyId.map(value => value)
      )
    def resources: Optional[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly
    ]]
    def sourceDetails: Optional[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly
    ]]
    def anomalyId: Optional[AnomalyId]
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getSourceDetails: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getAnomalyId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("anomalyId", anomalyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
  ) extends zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly {
    override val resources: Optional[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource
            .wrap(item)
        }.toList
      )
    override val sourceDetails: Optional[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail
            .wrap(item)
        }.toList
      )
    override val anomalyId: Optional[AnomalyId] = zio.aws.core.internal
      .optionalFromNullable(impl.anomalyId())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
  ): zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly =
    new Wrapper(impl)
}
