package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceCollectionType {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType
}
object ResourceCollectionType {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType
  ): zio.aws.devopsguru.model.ResourceCollectionType = value match {
    case software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.AWS_CLOUD_FORMATION =>
      val r = AWS_CLOUD_FORMATION
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.AWS_SERVICE =>
      val r = AWS_SERVICE
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.AWS_TAGS =>
      val r = AWS_TAGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.ResourceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType =
      software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_CLOUD_FORMATION
      extends zio.aws.devopsguru.model.ResourceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType =
      software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.AWS_CLOUD_FORMATION
  }
  case object AWS_SERVICE
      extends zio.aws.devopsguru.model.ResourceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType =
      software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.AWS_SERVICE
  }
  case object AWS_TAGS extends zio.aws.devopsguru.model.ResourceCollectionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType =
      software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType.AWS_TAGS
  }
}
