package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceCollectionFilter(
    cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCollectionFilter
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.devopsguru.model.TagCollectionFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ResourceCollectionFilter = {
    import ResourceCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ResourceCollectionFilter
      .builder()
      .optionallyWith(cloudFormation.map(value => value.buildAwsValue()))(
        _.cloudFormation
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ResourceCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.ResourceCollectionFilter.wrap(buildAwsValue())
}
object ResourceCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ResourceCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ResourceCollectionFilter =
      zio.aws.devopsguru.model.ResourceCollectionFilter(
        cloudFormation.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCollectionFilter.ReadOnly
    ]
    def tags
        : Optional[List[zio.aws.devopsguru.model.TagCollectionFilter.ReadOnly]]
    def getCloudFormation: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudFormationCollectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.TagCollectionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ResourceCollectionFilter
  ) extends zio.aws.devopsguru.model.ResourceCollectionFilter.ReadOnly {
    override val cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCollectionFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFormation())
      .map(value =>
        zio.aws.devopsguru.model.CloudFormationCollectionFilter.wrap(value)
      )
    override val tags: Optional[
      List[zio.aws.devopsguru.model.TagCollectionFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.TagCollectionFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ResourceCollectionFilter
  ): zio.aws.devopsguru.model.ResourceCollectionFilter.ReadOnly = new Wrapper(
    impl
  )
}
