package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{ResourceType, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnomalyResource(
    name: Optional[ResourceName] = Optional.Absent,
    `type`: Optional[ResourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalyResource = {
    import AnomalyResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalyResource
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalyResource.ReadOnly =
    zio.aws.devopsguru.model.AnomalyResource.wrap(buildAwsValue())
}
object AnomalyResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalyResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalyResource =
      zio.aws.devopsguru.model
        .AnomalyResource(name.map(value => value), `type`.map(value => value))
    def name: Optional[ResourceName]
    def `type`: Optional[ResourceType]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyResource
  ) extends zio.aws.devopsguru.model.AnomalyResource.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.ResourceName(value))
    override val `type`: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.devopsguru.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyResource
  ): zio.aws.devopsguru.model.AnomalyResource.ReadOnly = new Wrapper(impl)
}
