package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.StackName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateCloudFormationCollectionFilter(
    stackNames: Optional[Iterable[StackName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateCloudFormationCollectionFilter = {
    import UpdateCloudFormationCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateCloudFormationCollectionFilter
      .builder()
      .optionallyWith(
        stackNames.map(value =>
          value.map { item =>
            StackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackNames)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter
      .wrap(buildAwsValue())
}
object UpdateCloudFormationCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateCloudFormationCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter =
      zio.aws.devopsguru.model
        .UpdateCloudFormationCollectionFilter(stackNames.map(value => value))
    def stackNames: Optional[List[StackName]]
    def getStackNames: ZIO[Any, AwsError, List[StackName]] =
      AwsError.unwrapOptionField("stackNames", stackNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateCloudFormationCollectionFilter
  ) extends zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter.ReadOnly {
    override val stackNames: Optional[List[StackName]] = zio.aws.core.internal
      .optionalFromNullable(impl.stackNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.StackName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateCloudFormationCollectionFilter
  ): zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter.ReadOnly =
    new Wrapper(impl)
}
