package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EventTimeRange(fromTime: Timestamp, toTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.EventTimeRange = {
    import EventTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.EventTimeRange
      .builder()
      .fromTime(Timestamp.unwrap(fromTime): Instant)
      .toTime(Timestamp.unwrap(toTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.EventTimeRange.ReadOnly =
    zio.aws.devopsguru.model.EventTimeRange.wrap(buildAwsValue())
}
object EventTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.EventTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.EventTimeRange =
      zio.aws.devopsguru.model.EventTimeRange(fromTime, toTime)
    def fromTime: Timestamp
    def toTime: Timestamp
    def getFromTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(fromTime)
    def getToTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(toTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.EventTimeRange
  ) extends zio.aws.devopsguru.model.EventTimeRange.ReadOnly {
    override val fromTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.fromTime())
    override val toTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.toTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.EventTimeRange
  ): zio.aws.devopsguru.model.EventTimeRange.ReadOnly = new Wrapper(impl)
}
