package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  InsightName,
  OrganizationalUnitId,
  AwsAccountId,
  InsightId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProactiveOrganizationInsightSummary(
    id: Optional[InsightId] = Optional.Absent,
    accountId: Optional[AwsAccountId] = Optional.Absent,
    organizationalUnitId: Optional[OrganizationalUnitId] = Optional.Absent,
    name: Optional[InsightName] = Optional.Absent,
    severity: Optional[zio.aws.devopsguru.model.InsightSeverity] =
      Optional.Absent,
    status: Optional[zio.aws.devopsguru.model.InsightStatus] = Optional.Absent,
    insightTimeRange: Optional[zio.aws.devopsguru.model.InsightTimeRange] =
      Optional.Absent,
    predictionTimeRange: Optional[
      zio.aws.devopsguru.model.PredictionTimeRange
    ] = Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    serviceCollection: Optional[zio.aws.devopsguru.model.ServiceCollection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary = {
    import ProactiveOrganizationInsightSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        organizationalUnitId.map(value =>
          OrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .optionallyWith(
        name.map(value => InsightName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(insightTimeRange.map(value => value.buildAwsValue()))(
        _.insightTimeRange
      )
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly =
    zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary
      .wrap(buildAwsValue())
}
object ProactiveOrganizationInsightSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary =
      zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary(
        id.map(value => value),
        accountId.map(value => value),
        organizationalUnitId.map(value => value),
        name.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        insightTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        resourceCollection.map(value => value.asEditable),
        serviceCollection.map(value => value.asEditable)
      )
    def id: Optional[InsightId]
    def accountId: Optional[AwsAccountId]
    def organizationalUnitId: Optional[OrganizationalUnitId]
    def name: Optional[InsightName]
    def severity: Optional[zio.aws.devopsguru.model.InsightSeverity]
    def status: Optional[zio.aws.devopsguru.model.InsightStatus]
    def insightTimeRange
        : Optional[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly]
    def predictionTimeRange
        : Optional[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getOrganizationalUnitId: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
    def getName: ZIO[Any, AwsError, InsightName] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsightTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("insightTimeRange", insightTimeRange)
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
  ) extends zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly {
    override val id: Optional[InsightId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val accountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
    override val organizationalUnitId: Optional[OrganizationalUnitId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitId())
        .map(value =>
          zio.aws.devopsguru.model.primitives.OrganizationalUnitId(value)
        )
    override val name: Optional[InsightName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.InsightName(value))
    override val severity: Optional[zio.aws.devopsguru.model.InsightSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.devopsguru.model.InsightSeverity.wrap(value))
    override val status: Optional[zio.aws.devopsguru.model.InsightStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devopsguru.model.InsightStatus.wrap(value))
    override val insightTimeRange
        : Optional[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightTimeRange())
        .map(value => zio.aws.devopsguru.model.InsightTimeRange.wrap(value))
    override val predictionTimeRange
        : Optional[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionTimeRange())
        .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCollection())
        .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
  ): zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly =
    new Wrapper(impl)
}
