package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceCollection(
    serviceNames: Optional[Iterable[zio.aws.devopsguru.model.ServiceName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ServiceCollection = {
    import ServiceCollection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ServiceCollection
      .builder()
      .optionallyWith(
        serviceNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceNamesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ServiceCollection.ReadOnly =
    zio.aws.devopsguru.model.ServiceCollection.wrap(buildAwsValue())
}
object ServiceCollection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ServiceCollection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ServiceCollection =
      zio.aws.devopsguru.model
        .ServiceCollection(serviceNames.map(value => value))
    def serviceNames: Optional[List[zio.aws.devopsguru.model.ServiceName]]
    def getServiceNames
        : ZIO[Any, AwsError, List[zio.aws.devopsguru.model.ServiceName]] =
      AwsError.unwrapOptionField("serviceNames", serviceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceCollection
  ) extends zio.aws.devopsguru.model.ServiceCollection.ReadOnly {
    override val serviceNames
        : Optional[List[zio.aws.devopsguru.model.ServiceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.ServiceName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceCollection
  ): zio.aws.devopsguru.model.ServiceCollection.ReadOnly = new Wrapper(impl)
}
