package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.RecommendationRelatedEventName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecommendationRelatedEvent(
    name: Option[RecommendationRelatedEventName] = None,
    resources: Option[
      Iterable[zio.aws.devopsguru.model.RecommendationRelatedEventResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEvent = {
    import RecommendationRelatedEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEvent
      .builder()
      .optionallyWith(
        name.map(value =>
          RecommendationRelatedEventName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.RecommendationRelatedEvent.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedEvent.wrap(buildAwsValue())
}
object RecommendationRelatedEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.RecommendationRelatedEvent =
      zio.aws.devopsguru.model.RecommendationRelatedEvent(
        name.map(value => value),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[RecommendationRelatedEventName]
    def resources: Option[
      List[zio.aws.devopsguru.model.RecommendationRelatedEventResource.ReadOnly]
    ]
    def getName: ZIO[Any, AwsError, RecommendationRelatedEventName] =
      AwsError.unwrapOptionField("name", name)
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedEventResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEvent
  ) extends zio.aws.devopsguru.model.RecommendationRelatedEvent.ReadOnly {
    override val name: Option[RecommendationRelatedEventName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .RecommendationRelatedEventName(value)
      )
    override val resources: Option[
      List[zio.aws.devopsguru.model.RecommendationRelatedEventResource.ReadOnly]
    ] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedEventResource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEvent
  ): zio.aws.devopsguru.model.RecommendationRelatedEvent.ReadOnly = new Wrapper(
    impl
  )
}
