package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpsCenterIntegration(
    optInStatus: Option[zio.aws.devopsguru.model.OptInStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegration = {
    import OpsCenterIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegration
      .builder()
      .optionallyWith(optInStatus.map(value => value.unwrap))(_.optInStatus)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.OpsCenterIntegration.ReadOnly =
    zio.aws.devopsguru.model.OpsCenterIntegration.wrap(buildAwsValue())
}
object OpsCenterIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.OpsCenterIntegration =
      zio.aws.devopsguru.model
        .OpsCenterIntegration(optInStatus.map(value => value))
    def optInStatus: Option[zio.aws.devopsguru.model.OptInStatus]
    def getOptInStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.OptInStatus] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegration
  ) extends zio.aws.devopsguru.model.OpsCenterIntegration.ReadOnly {
    override val optInStatus: Option[zio.aws.devopsguru.model.OptInStatus] =
      scala
        .Option(impl.optInStatus())
        .map(value => zio.aws.devopsguru.model.OptInStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegration
  ): zio.aws.devopsguru.model.OpsCenterIntegration.ReadOnly = new Wrapper(impl)
}
