package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AmazonCodeGuruProfilerIntegration(
    status: Option[zio.aws.devopsguru.model.EventSourceOptInStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration = {
    import AmazonCodeGuruProfilerIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly =
    zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration
      .wrap(buildAwsValue())
}
object AmazonCodeGuruProfilerIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration =
      zio.aws.devopsguru.model
        .AmazonCodeGuruProfilerIntegration(status.map(value => value))
    def status: Option[zio.aws.devopsguru.model.EventSourceOptInStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.EventSourceOptInStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
  ) extends zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly {
    override val status
        : Option[zio.aws.devopsguru.model.EventSourceOptInStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devopsguru.model.EventSourceOptInStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
  ): zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly =
    new Wrapper(impl)
}
