package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{ResourceArn, InsightName, InsightId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ProactiveInsightSummary(
    id: Option[InsightId] = None,
    name: Option[InsightName] = None,
    severity: Option[zio.aws.devopsguru.model.InsightSeverity] = None,
    status: Option[zio.aws.devopsguru.model.InsightStatus] = None,
    insightTimeRange: Option[zio.aws.devopsguru.model.InsightTimeRange] = None,
    predictionTimeRange: Option[zio.aws.devopsguru.model.PredictionTimeRange] =
      None,
    resourceCollection: Option[zio.aws.devopsguru.model.ResourceCollection] =
      None,
    serviceCollection: Option[zio.aws.devopsguru.model.ServiceCollection] =
      None,
    associatedResourceArns: Option[Iterable[ResourceArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary = {
    import ProactiveInsightSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => InsightName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(insightTimeRange.map(value => value.buildAwsValue()))(
        _.insightTimeRange
      )
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .optionallyWith(
        associatedResourceArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedResourceArns)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly =
    zio.aws.devopsguru.model.ProactiveInsightSummary.wrap(buildAwsValue())
}
object ProactiveInsightSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ProactiveInsightSummary =
      zio.aws.devopsguru.model.ProactiveInsightSummary(
        id.map(value => value),
        name.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        insightTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        resourceCollection.map(value => value.asEditable),
        serviceCollection.map(value => value.asEditable),
        associatedResourceArns.map(value => value)
      )
    def id: Option[InsightId]
    def name: Option[InsightName]
    def severity: Option[zio.aws.devopsguru.model.InsightSeverity]
    def status: Option[zio.aws.devopsguru.model.InsightStatus]
    def insightTimeRange
        : Option[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly]
    def predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def serviceCollection
        : Option[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def associatedResourceArns: Option[List[ResourceArn]]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, InsightName] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsightTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("insightTimeRange", insightTimeRange)
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
    def getAssociatedResourceArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField(
        "associatedResourceArns",
        associatedResourceArns
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary
  ) extends zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly {
    override val id: Option[InsightId] = scala
      .Option(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val name: Option[InsightName] = scala
      .Option(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.InsightName(value))
    override val severity: Option[zio.aws.devopsguru.model.InsightSeverity] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.devopsguru.model.InsightSeverity.wrap(value))
    override val status: Option[zio.aws.devopsguru.model.InsightStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devopsguru.model.InsightStatus.wrap(value))
    override val insightTimeRange
        : Option[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly] = scala
      .Option(impl.insightTimeRange())
      .map(value => zio.aws.devopsguru.model.InsightTimeRange.wrap(value))
    override val predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] = scala
      .Option(impl.predictionTimeRange())
      .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] = scala
      .Option(impl.resourceCollection())
      .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val serviceCollection
        : Option[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] = scala
      .Option(impl.serviceCollection())
      .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
    override val associatedResourceArns: Option[List[ResourceArn]] = scala
      .Option(impl.associatedResourceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.ResourceArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary
  ): zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly = new Wrapper(
    impl
  )
}
