package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.AnomalyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecommendationRelatedAnomaly(
    resources: Option[
      Iterable[zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource]
    ] = None,
    sourceDetails: Option[Iterable[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail
    ]] = None,
    anomalyId: Option[AnomalyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly = {
    import RecommendationRelatedAnomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        sourceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDetails)
      .optionallyWith(
        anomalyId.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.anomalyId)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedAnomaly.wrap(buildAwsValue())
}
object RecommendationRelatedAnomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.RecommendationRelatedAnomaly =
      zio.aws.devopsguru.model.RecommendationRelatedAnomaly(
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        anomalyId.map(value => value)
      )
    def resources: Option[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly
    ]]
    def sourceDetails: Option[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly
    ]]
    def anomalyId: Option[AnomalyId]
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getSourceDetails: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getAnomalyId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("anomalyId", anomalyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
  ) extends zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly {
    override val resources: Option[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly
    ]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource
            .wrap(item)
        }.toList
      )
    override val sourceDetails: Option[List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly
    ]] = scala
      .Option(impl.sourceDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail
            .wrap(item)
        }.toList
      )
    override val anomalyId: Option[AnomalyId] = scala
      .Option(impl.anomalyId())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly
  ): zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly =
    new Wrapper(impl)
}
