package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEventsResponse(
    events: Iterable[zio.aws.devopsguru.model.Event],
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListEventsResponse = {
    import ListEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListEventsResponse
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListEventsResponse.ReadOnly =
    zio.aws.devopsguru.model.ListEventsResponse.wrap(buildAwsValue())
}
object ListEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListEventsResponse =
      zio.aws.devopsguru.model.ListEventsResponse(
        events.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def events: List[zio.aws.devopsguru.model.Event.ReadOnly]
    def nextToken: Option[UuidNextToken]
    def getEvents
        : ZIO[Any, Nothing, List[zio.aws.devopsguru.model.Event.ReadOnly]] =
      ZIO.succeed(events)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListEventsResponse
  ) extends zio.aws.devopsguru.model.ListEventsResponse.ReadOnly {
    override val events: List[zio.aws.devopsguru.model.Event.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.Event.wrap(item)
      }
      .toList
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListEventsResponse
  ): zio.aws.devopsguru.model.ListEventsResponse.ReadOnly = new Wrapper(impl)
}
