package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateEventSourcesConfigRequest(
    eventSources: Option[zio.aws.devopsguru.model.EventSourcesConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest = {
    import UpdateEventSourcesConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest
      .builder()
      .optionallyWith(eventSources.map(value => value.buildAwsValue()))(
        _.eventSources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateEventSourcesConfigRequest.ReadOnly =
    zio.aws.devopsguru.model.UpdateEventSourcesConfigRequest
      .wrap(buildAwsValue())
}
object UpdateEventSourcesConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateEventSourcesConfigRequest =
      zio.aws.devopsguru.model.UpdateEventSourcesConfigRequest(
        eventSources.map(value => value.asEditable)
      )
    def eventSources
        : Option[zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly]
    def getEventSources: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly
    ] = AwsError.unwrapOptionField("eventSources", eventSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest
  ) extends zio.aws.devopsguru.model.UpdateEventSourcesConfigRequest.ReadOnly {
    override val eventSources
        : Option[zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly] = scala
      .Option(impl.eventSources())
      .map(value => zio.aws.devopsguru.model.EventSourcesConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest
  ): zio.aws.devopsguru.model.UpdateEventSourcesConfigRequest.ReadOnly =
    new Wrapper(impl)
}
