package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{TagValue, AppBoundaryKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagHealth(
    appBoundaryKey: Option[AppBoundaryKey] = None,
    tagValue: Option[TagValue] = None,
    insight: Option[zio.aws.devopsguru.model.InsightHealth] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.TagHealth = {
    import TagHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.TagHealth
      .builder()
      .optionallyWith(
        appBoundaryKey.map(value =>
          AppBoundaryKey.unwrap(value): java.lang.String
        )
      )(_.appBoundaryKey)
      .optionallyWith(
        tagValue.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.tagValue)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.TagHealth.ReadOnly =
    zio.aws.devopsguru.model.TagHealth.wrap(buildAwsValue())
}
object TagHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.TagHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.TagHealth =
      zio.aws.devopsguru.model.TagHealth(
        appBoundaryKey.map(value => value),
        tagValue.map(value => value),
        insight.map(value => value.asEditable)
      )
    def appBoundaryKey: Option[AppBoundaryKey]
    def tagValue: Option[TagValue]
    def insight: Option[zio.aws.devopsguru.model.InsightHealth.ReadOnly]
    def getAppBoundaryKey: ZIO[Any, AwsError, AppBoundaryKey] =
      AwsError.unwrapOptionField("appBoundaryKey", appBoundaryKey)
    def getTagValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("tagValue", tagValue)
    def getInsight
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightHealth.ReadOnly] =
      AwsError.unwrapOptionField("insight", insight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.TagHealth
  ) extends zio.aws.devopsguru.model.TagHealth.ReadOnly {
    override val appBoundaryKey: Option[AppBoundaryKey] = scala
      .Option(impl.appBoundaryKey())
      .map(value => zio.aws.devopsguru.model.primitives.AppBoundaryKey(value))
    override val tagValue: Option[TagValue] = scala
      .Option(impl.tagValue())
      .map(value => zio.aws.devopsguru.model.primitives.TagValue(value))
    override val insight
        : Option[zio.aws.devopsguru.model.InsightHealth.ReadOnly] = scala
      .Option(impl.insight())
      .map(value => zio.aws.devopsguru.model.InsightHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.TagHealth
  ): zio.aws.devopsguru.model.TagHealth.ReadOnly = new Wrapper(impl)
}
