package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  SearchInsightsMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchInsightsRequest(
    startTimeRange: zio.aws.devopsguru.model.StartTimeRange,
    filters: Option[zio.aws.devopsguru.model.SearchInsightsFilters] = None,
    maxResults: Option[SearchInsightsMaxResults] = None,
    nextToken: Option[UuidNextToken] = None,
    `type`: zio.aws.devopsguru.model.InsightType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest = {
    import SearchInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest
      .builder()
      .startTimeRange(startTimeRange.buildAwsValue())
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => SearchInsightsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.SearchInsightsRequest.ReadOnly =
    zio.aws.devopsguru.model.SearchInsightsRequest.wrap(buildAwsValue())
}
object SearchInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.SearchInsightsRequest =
      zio.aws.devopsguru.model.SearchInsightsRequest(
        startTimeRange.asEditable,
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        `type`
      )
    def startTimeRange: zio.aws.devopsguru.model.StartTimeRange.ReadOnly
    def filters: Option[zio.aws.devopsguru.model.SearchInsightsFilters.ReadOnly]
    def maxResults: Option[SearchInsightsMaxResults]
    def nextToken: Option[UuidNextToken]
    def `type`: zio.aws.devopsguru.model.InsightType
    def getStartTimeRange
        : ZIO[Any, Nothing, zio.aws.devopsguru.model.StartTimeRange.ReadOnly] =
      ZIO.succeed(startTimeRange)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.SearchInsightsFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, SearchInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getType: ZIO[Any, Nothing, zio.aws.devopsguru.model.InsightType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest
  ) extends zio.aws.devopsguru.model.SearchInsightsRequest.ReadOnly {
    override val startTimeRange
        : zio.aws.devopsguru.model.StartTimeRange.ReadOnly =
      zio.aws.devopsguru.model.StartTimeRange.wrap(impl.startTimeRange())
    override val filters
        : Option[zio.aws.devopsguru.model.SearchInsightsFilters.ReadOnly] =
      scala
        .Option(impl.filters())
        .map(value =>
          zio.aws.devopsguru.model.SearchInsightsFilters.wrap(value)
        )
    override val maxResults: Option[SearchInsightsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.devopsguru.model.primitives.SearchInsightsMaxResults(value)
      )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val `type`: zio.aws.devopsguru.model.InsightType =
      zio.aws.devopsguru.model.InsightType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest
  ): zio.aws.devopsguru.model.SearchInsightsRequest.ReadOnly = new Wrapper(impl)
}
