package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchInsightsResponse(
    proactiveInsights: Option[
      Iterable[zio.aws.devopsguru.model.ProactiveInsightSummary]
    ] = None,
    reactiveInsights: Option[
      Iterable[zio.aws.devopsguru.model.ReactiveInsightSummary]
    ] = None,
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse = {
    import SearchInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse
      .builder()
      .optionallyWith(
        proactiveInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proactiveInsights)
      .optionallyWith(
        reactiveInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reactiveInsights)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly =
    zio.aws.devopsguru.model.SearchInsightsResponse.wrap(buildAwsValue())
}
object SearchInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.SearchInsightsResponse =
      zio.aws.devopsguru.model.SearchInsightsResponse(
        proactiveInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reactiveInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proactiveInsights: Option[
      List[zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly]
    ]
    def reactiveInsights
        : Option[List[zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly]]
    def nextToken: Option[UuidNextToken]
    def getProactiveInsights: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("proactiveInsights", proactiveInsights)
    def getReactiveInsights: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("reactiveInsights", reactiveInsights)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse
  ) extends zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly {
    override val proactiveInsights: Option[
      List[zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly]
    ] = scala
      .Option(impl.proactiveInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ProactiveInsightSummary.wrap(item)
        }.toList
      )
    override val reactiveInsights: Option[
      List[zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly]
    ] = scala
      .Option(impl.reactiveInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ReactiveInsightSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse
  ): zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly = new Wrapper(
    impl
  )
}
